/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;

public class PolyBlob
implements Blob {
    byte[] value;
    boolean isFreed = false;

    public PolyBlob() {
    }

    public PolyBlob(byte[] bytes) {
        this.value = bytes;
    }

    private long positionToIndex(long position) {
        return position - 1L;
    }

    private long indexToPosition(long index) {
        return index + 1L;
    }

    private int longToInt(long value) {
        return Math.toIntExact(value);
    }

    private void throwIfPositionOutOfBounds(long position) throws SQLException {
        this.throwIfIndexOutOfBounds(this.positionToIndex(position));
    }

    private void throwIfIndexOutOfBounds(long index) throws SQLException {
        if (index < 0L) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Index out of bounds");
        }
        if (index >= (long)this.value.length) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Index out of bounds");
        }
    }

    private void throwIfFreed() throws SQLException {
        if (this.isFreed) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation on freed blob");
        }
    }

    @Override
    public long length() throws SQLException {
        return this.value.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.throwIfFreed();
        this.throwIfPositionOutOfBounds(pos);
        this.throwIfPositionOutOfBounds(pos + (long)length - 1L);
        pos = this.positionToIndex(pos);
        return Arrays.copyOfRange(this.value, this.longToInt(pos), length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.throwIfFreed();
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public long position(byte[] bytes, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not implemented");
    }

    @Override
    public long position(Blob blob, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not implemented");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.throwIfFreed();
        if (this.value == null) {
            this.value = new byte[len];
        }
        if (this.positionToIndex(pos + (long)len) >= (long)this.value.length) {
            this.value = Arrays.copyOf(this.value, this.longToInt(this.positionToIndex(pos + (long)len)));
        }
        for (int bytesWritten = 0; bytesWritten < len; ++bytesWritten) {
            int writeIndex = this.longToInt(this.positionToIndex(pos)) + bytesWritten;
            this.value[writeIndex] = bytes[offset + bytesWritten];
        }
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.throwIfFreed();
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.throwIfFreed();
        if (len < 0L) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal argument for len");
        }
        len = Math.min(len, (long)this.value.length);
        this.value = Arrays.copyOf(this.value, this.longToInt(len));
    }

    @Override
    public void free() throws SQLException {
        this.isFreed = true;
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        this.throwIfFreed();
        int from = this.longToInt(this.positionToIndex(pos));
        int to = this.longToInt(this.positionToIndex(pos + len));
        byte[] slice = Arrays.copyOfRange(this.value, from, to);
        return new ByteArrayInputStream(slice);
    }
}

