/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;

public class PolyClob
implements Clob,
NClob {
    String value;
    boolean isFreed;

    private void throwIfFreed() throws SQLException {
        if (this.isFreed) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation on freed blob");
        }
    }

    public PolyClob(String string) {
        this.isFreed = false;
        this.value = string;
    }

    public PolyClob() {
    }

    private long positionToIndex(long position) {
        return position - 1L;
    }

    private long indexToPosition(long index) {
        return index + 1L;
    }

    private int longToInt(long value) {
        return Math.toIntExact(value);
    }

    @Override
    public long length() throws SQLException {
        this.throwIfFreed();
        return this.value.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.throwIfFreed();
        int startIndex = this.longToInt(this.positionToIndex(pos));
        return this.value.substring(startIndex, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.throwIfFreed();
        return new StringReader(this.value);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.throwIfFreed();
        return new ByteArrayInputStream(this.value.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        this.throwIfFreed();
        int startIndex = this.longToInt(this.positionToIndex(start));
        return this.value.indexOf(searchStr, startIndex);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        this.throwIfFreed();
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.throwIfFreed();
        this.replaceSection(this.longToInt(this.positionToIndex(pos)), str.length(), str);
        return str.length();
    }

    private void replaceSection(int startIndex, int replacementLength, String replacement) throws PrismInterfaceServiceException {
        if (this.value == null) {
            if (startIndex > 0) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Can't replace section in empty string");
            }
            this.value = replacement;
            return;
        }
        this.value = this.value.substring(0, startIndex) + replacement + this.value.substring(startIndex + replacementLength);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.throwIfFreed();
        int startIndex = this.longToInt(this.positionToIndex(offset));
        int endIndex = this.longToInt(this.positionToIndex(offset + len));
        String replacement = str.substring(startIndex, endIndex);
        return this.setString(pos, replacement);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.throwIfFreed();
        throw new SQLFeatureNotSupportedException("feature not supported");
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        this.throwIfFreed();
        throw new SQLFeatureNotSupportedException("feature not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.throwIfFreed();
        this.value = this.value.substring(0, this.longToInt(len));
    }

    @Override
    public void free() throws SQLException {
        this.isFreed = true;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.throwIfFreed();
        int startIndex = this.longToInt(this.positionToIndex(pos));
        String slice = this.value.substring(startIndex, startIndex + this.longToInt(length));
        return null;
    }
}

