/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.polypheny.jdbc.dependency.prism.ProtoDocument;
import org.polypheny.jdbc.dependency.prism.ProtoEntry;
import org.polypheny.jdbc.dependency.prism.ProtoValue;
import org.polypheny.jdbc.types.TypedValue;
import org.polypheny.jdbc.utils.ProtoUtils;

public class PolyDocument
extends HashMap<String, TypedValue> {
    public PolyDocument() {
    }

    public PolyDocument(HashMap<String, TypedValue> entries) {
        super(entries);
    }

    public PolyDocument(ProtoDocument document) {
        document.getEntriesList().stream().filter(e -> e.getKey().getValueCase() == ProtoValue.ValueCase.STRING).forEach((? super T e) -> this.put(e.getKey().getString().getString(), new TypedValue(e.getValue())));
    }

    public ProtoDocument serialize() {
        List protoEntries = this.entrySet().stream().map(entry -> {
            ProtoValue protoValue;
            ProtoValue protoKey = ProtoUtils.serializeAsProtoString((String)entry.getKey());
            try {
                protoValue = ((TypedValue)entry.getValue()).serialize();
            }
            catch (SQLException e) {
                throw new RuntimeException("Should not be thrown. Unknown value encountered.");
            }
            return ProtoEntry.newBuilder().setKey(protoKey).setValue(protoValue).build();
        }).collect(Collectors.toList());
        return ProtoDocument.newBuilder().addAllEntries(protoEntries).build();
    }
}

