/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.util.HashMap;
import java.util.Map;
import org.polypheny.jdbc.dependency.prism.ProtoPolyType;

public class ProtoToJdbcTypeMap {
    private static final Map<ProtoPolyType, Integer> PROTO_TYPE_TO_JDBC = new HashMap<ProtoPolyType, Integer>();

    public static int getJdbcTypeFromProto(ProtoPolyType ProtoPolyType2) {
        Integer jdbcType = PROTO_TYPE_TO_JDBC.get(ProtoPolyType2);
        if (jdbcType == null) {
            throw new IllegalArgumentException("Invalid proto value type: " + ProtoPolyType2.name() + ".");
        }
        return jdbcType;
    }

    static {
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.BOOLEAN, 16);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.TINYINT, -6);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.SMALLINT, 5);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.INTEGER, 4);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.BIGINT, -5);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DECIMAL, 3);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.REAL, 7);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.FLOAT, 6);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DOUBLE, 8);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DATE, 91);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.TIME, 92);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.TIMESTAMP, 93);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.INTERVAL, 1111);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.CHAR, 1);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.VARCHAR, 12);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.TEXT, 12);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.BINARY, -2);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.VARBINARY, -3);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.NULL, 0);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.ARRAY, 2003);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.MAP, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DOCUMENT, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.GRAPH, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.NODE, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.EDGE, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.PATH, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.IMAGE, -2);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.VIDEO, -2);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.AUDIO, -2);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.FILE, -2);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DISTINCT, 2001);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.STRUCTURED, 2002);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.OTHER, 1111);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.CURSOR, 2012);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.COLUMN_LIST, 1113);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.DYNAMIC_STAR, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.GEOMETRY, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.SYMBOL, 1111);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.JSON, 12);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.MULTISET, 2003);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.ANY, 2000);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.USER_DEFINED_TYPE, 1111);
        PROTO_TYPE_TO_JDBC.put(ProtoPolyType.ROW, -8);
    }
}

