/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.com.google.protobuf.ByteString;
import org.polypheny.jdbc.dependency.prism.ProtoBigDecimal;
import org.polypheny.jdbc.dependency.prism.ProtoBinary;
import org.polypheny.jdbc.dependency.prism.ProtoBoolean;
import org.polypheny.jdbc.dependency.prism.ProtoDate;
import org.polypheny.jdbc.dependency.prism.ProtoDouble;
import org.polypheny.jdbc.dependency.prism.ProtoFile;
import org.polypheny.jdbc.dependency.prism.ProtoFloat;
import org.polypheny.jdbc.dependency.prism.ProtoInteger;
import org.polypheny.jdbc.dependency.prism.ProtoInterval;
import org.polypheny.jdbc.dependency.prism.ProtoList;
import org.polypheny.jdbc.dependency.prism.ProtoLong;
import org.polypheny.jdbc.dependency.prism.ProtoNull;
import org.polypheny.jdbc.dependency.prism.ProtoTime;
import org.polypheny.jdbc.dependency.prism.ProtoTimestamp;
import org.polypheny.jdbc.dependency.prism.ProtoValue;
import org.polypheny.jdbc.properties.DriverProperties;
import org.polypheny.jdbc.types.Convertible;
import org.polypheny.jdbc.types.PolyArray;
import org.polypheny.jdbc.types.PolyBlob;
import org.polypheny.jdbc.types.PolyClob;
import org.polypheny.jdbc.types.PolyDocument;
import org.polypheny.jdbc.types.PolyInterval;
import org.polypheny.jdbc.types.UDTPrototype;
import org.polypheny.jdbc.utils.ProtoUtils;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class TypedValue
implements Convertible {
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final Set<ProtoValue.ValueCase> customTypes = new HashSet<ProtoValue.ValueCase>(Arrays.asList(ProtoValue.ValueCase.DOCUMENT, ProtoValue.ValueCase.INTERVAL));
    private ProtoValue serialized;
    private ProtoValue.ValueCase valueCase;
    private boolean isSerialized = true;
    private Boolean booleanValue;
    private Integer integerValue;
    private Long bigintValue;
    private Float floatValue;
    private Double doubleValue;
    private BigDecimal bigDecimalValue;
    private byte[] binaryValue;
    private Blob blobValue;
    private Date dateValue;
    private Time timeValue;
    private Timestamp timestampValue;
    private String varcharValue;
    private Array arrayValue;
    private RowId rowIdValue;
    private Object otherValue;

    public TypedValue(ProtoValue value) {
        this.serialized = value;
        this.valueCase = this.serialized.getValueCase();
    }

    private TypedValue() {
        this.isSerialized = false;
    }

    public static TypedValue fromBoolean(boolean booleanValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.BOOLEAN;
        value.booleanValue = booleanValue;
        return value;
    }

    public static TypedValue fromByte(byte byteValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.INTEGER;
        value.integerValue = byteValue;
        return value;
    }

    public static TypedValue fromShort(short shortValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.INTEGER;
        value.integerValue = shortValue;
        return value;
    }

    public static TypedValue fromInteger(int intValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.INTEGER;
        value.integerValue = intValue;
        return value;
    }

    public static TypedValue fromLong(long bigintValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.LONG;
        value.bigintValue = bigintValue;
        return value;
    }

    public static TypedValue fromFloat(float floatValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.FLOAT;
        value.floatValue = Float.valueOf(floatValue);
        return value;
    }

    public static TypedValue fromDouble(double doubleValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.DOUBLE;
        value.doubleValue = doubleValue;
        return value;
    }

    public static TypedValue fromBigDecimal(BigDecimal bigDecimalValue) {
        if (bigDecimalValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.BIG_DECIMAL;
        value.bigDecimalValue = bigDecimalValue;
        return value;
    }

    public static TypedValue fromString(String stringValue) {
        if (stringValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.STRING;
        value.varcharValue = stringValue;
        return value;
    }

    public static TypedValue fromBytes(byte[] binaryValue) {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.BINARY;
        value.binaryValue = binaryValue;
        return value;
    }

    public static TypedValue fromDate(Date dateValue) {
        if (dateValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.DATE;
        value.dateValue = dateValue;
        return value;
    }

    public static TypedValue fromDate(Date dateValue, Calendar calendar) {
        if (dateValue == null) {
            return TypedValue.fromNull();
        }
        return TypedValue.fromDate(TypedValueUtils.getDateInCalendar(dateValue, calendar));
    }

    public static TypedValue fromTime(Time timeValue) {
        if (timeValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.TIME;
        value.timeValue = timeValue;
        return value;
    }

    public static TypedValue fromTime(Time timeValue, Calendar calendar) {
        return TypedValue.fromTime(TypedValueUtils.getTimeInCalendar(timeValue, calendar));
    }

    public static TypedValue fromTimestamp(Timestamp timestampValue) {
        if (timestampValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.TIMESTAMP;
        value.timestampValue = timestampValue;
        return value;
    }

    public static TypedValue fromTimestamp(Timestamp timestampValue, Calendar calendar) {
        return TypedValue.fromTimestamp(TypedValueUtils.getTimestampInCalendar(timestampValue, calendar));
    }

    public static TypedValue fromAsciiStream(InputStream asciiStream, int length) throws SQLException {
        return TypedValue.fromAsciiStream(asciiStream);
    }

    public static TypedValue fromAsciiStream(InputStream asciiStream, long length) throws SQLException {
        return TypedValue.fromAsciiStream(asciiStream);
    }

    public static TypedValue fromAsciiStream(InputStream asciiStream) throws SQLException {
        try {
            return TypedValue.fromString(new String(TypedValue.collectByteStream(asciiStream), StandardCharsets.US_ASCII));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read from ascii stream.", (Throwable)e);
        }
    }

    public static TypedValue fromUnicodeStream(InputStream unicodeStream, int length) throws SQLException {
        try {
            return TypedValue.fromString(new String(TypedValue.collectByteStream(unicodeStream), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read from unicode stream.", (Throwable)e);
        }
    }

    public static TypedValue fromBinaryStream(InputStream binaryStream, int length) throws SQLException {
        return TypedValue.fromBinaryStream(binaryStream);
    }

    public static TypedValue fromBinaryStream(InputStream binaryStream, long length) throws SQLException {
        return TypedValue.fromBinaryStream(binaryStream);
    }

    public static TypedValue fromBinaryStream(InputStream binaryStream) throws SQLException {
        try {
            return TypedValue.fromBytes(TypedValue.collectByteStream(binaryStream));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read from binary stream.", (Throwable)e);
        }
    }

    public static TypedValue fromCharacterStream(Reader characterStream, int length) throws SQLException {
        return TypedValue.fromCharacterStream(characterStream);
    }

    public static TypedValue fromCharacterStream(Reader characterStream, long length) throws SQLException {
        return TypedValue.fromCharacterStream(characterStream);
    }

    public static TypedValue fromCharacterStream(Reader characterStream) throws SQLException {
        try {
            return TypedValue.fromString(TypedValue.collectCharacterStream(characterStream));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read from character stream.", (Throwable)e);
        }
    }

    public static TypedValue fromRef(Ref refValue) throws SQLException {
        throw new SQLFeatureNotSupportedException("Refs are not supported yet.");
    }

    public static TypedValue fromDocument(PolyDocument document) {
        if (document == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.DOCUMENT;
        value.otherValue = document;
        return value;
    }

    public static TypedValue fromInterval(PolyInterval interval) {
        if (interval == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.INTERVAL;
        value.otherValue = interval;
        return value;
    }

    public static TypedValue fromBlob(Blob blobValue) {
        if (blobValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.FILE;
        value.blobValue = blobValue;
        return value;
    }

    public static TypedValue fromBlob(InputStream binaryStream) throws SQLException {
        try {
            return TypedValue.fromBlob(new PolyBlob(TypedValue.collectByteStream(binaryStream)));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read blob form binary stream.", (Throwable)e);
        }
    }

    public static TypedValue fromBlob(InputStream binaryStream, long length) throws SQLException {
        return TypedValue.fromBlob(binaryStream);
    }

    public static TypedValue fromNull() {
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.NULL;
        return value;
    }

    public static TypedValue fromClob(Clob clobValue) throws SQLException {
        try {
            return TypedValue.fromString(TypedValue.collectCharacterStream(clobValue.getCharacterStream()));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read data from clob.", (Throwable)e);
        }
    }

    public static TypedValue fromClob(Reader reader) throws SQLException {
        try {
            return TypedValue.fromString(TypedValue.collectCharacterStream(reader));
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read data from streamed clob.", (Throwable)e);
        }
    }

    public static TypedValue fromClob(Reader reader, long length) throws SQLException {
        return TypedValue.fromClob(reader);
    }

    public static TypedValue fromArray(Array arrayValue) {
        if (arrayValue == null) {
            return TypedValue.fromNull();
        }
        TypedValue value = new TypedValue();
        value.valueCase = ProtoValue.ValueCase.LIST;
        value.arrayValue = arrayValue;
        return value;
    }

    public static TypedValue fromUrl(URL urlValue) throws SQLException {
        throw new SQLFeatureNotSupportedException("URLs are not supported yet.");
    }

    public static TypedValue fromRowId(RowId rowIdValue) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("RowIds are not supported yet.");
    }

    public static TypedValue fromObject(Object value) throws SQLException {
        try {
            return TypedValueUtils.buildTypedValueFromObject(value);
        }
        catch (SQLFeatureNotSupportedException | ParseException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "Conversion from object failed.", (Throwable)e);
        }
    }

    public static TypedValue fromObject(Object value, int targetSqlType) throws SQLException {
        try {
            return TypedValueUtils.buildTypedValueFromObject(value, targetSqlType);
        }
        catch (SQLFeatureNotSupportedException | ParseException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "Conversion from object failed.", (Throwable)e);
        }
    }

    public static TypedValue fromObject(Object value, int targetSqlType, int scaleOrLength) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("This feature is not supported yet.");
    }

    public static TypedValue fromNString(String stringValue) {
        return TypedValue.fromString(stringValue);
    }

    public static TypedValue fromNCharacterStream(Reader character) throws SQLException {
        return TypedValue.fromCharacterStream(character);
    }

    public static TypedValue fromNCharacterStream(Reader characterStream, long length) throws SQLException {
        return TypedValue.fromCharacterStream(characterStream, length);
    }

    public static TypedValue fromNClob(NClob nClobValue) throws SQLException {
        return TypedValue.fromClob(nClobValue.getCharacterStream());
    }

    public static TypedValue fromNClob(Reader characterStream) throws SQLException {
        return TypedValue.fromClob(characterStream);
    }

    public static TypedValue fromNClob(Reader characterStream, int length) throws SQLException {
        return TypedValue.fromClob(characterStream, length);
    }

    public static TypedValue fromNClob(Reader characterStream, long length) throws SQLException {
        return TypedValue.fromClob(characterStream, length);
    }

    public static TypedValue fromSQLXML(SQLXML sqlxmlValue) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML is not yet supported.");
    }

    public static TypedValue fromStruct(Struct value) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Structs are not yet supported.");
    }

    @Override
    public boolean isNull() {
        return this.valueCase == ProtoValue.ValueCase.NULL;
    }

    public boolean isUdt() {
        return false;
    }

    public int getLength() {
        if (this.isSerialized) {
            this.deserialize();
        }
        switch (this.valueCase) {
            case BINARY: {
                return this.binaryValue.length;
            }
            case STRING: {
                return this.varcharValue.length();
            }
        }
        return 0;
    }

    public TypedValue getTrimmed(int length) {
        switch (this.valueCase) {
            case BINARY: {
                byte[] binaryData = Arrays.copyOfRange(this.binaryValue, 0, length);
                return TypedValue.fromBytes(binaryData);
            }
            case STRING: {
                String string = this.varcharValue.substring(0, length);
                return TypedValue.fromString(string);
            }
        }
        return this;
    }

    @Override
    public String asString() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return this.varcharValue;
        }
        if (this.isNull()) {
            return null;
        }
        switch (this.valueCase) {
            case BOOLEAN: {
                return this.booleanValue != false ? "1" : "0";
            }
            case INTEGER: {
                return this.integerValue.toString();
            }
            case LONG: {
                return this.bigintValue.toString();
            }
            case BIG_DECIMAL: {
                return this.bigDecimalValue.toString();
            }
            case FLOAT: {
                return this.floatValue.toString();
            }
            case DOUBLE: {
                return this.doubleValue.toString();
            }
            case DATE: {
                return this.dateValue.toString();
            }
            case TIME: {
                return this.timeValue.toString();
            }
            case TIMESTAMP: {
                return this.timestampValue.toString();
            }
            case INTERVAL: {
                return ((PolyInterval)this.otherValue).toString();
            }
            case BINARY: {
                return Arrays.toString(this.binaryValue);
            }
            case NULL: {
                return null;
            }
            case LIST: 
            case FILE: 
            case DOCUMENT: {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value cannot be returned as a string.");
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value cannot be returned as a string.");
    }

    @Override
    public boolean asBoolean() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.booleanValue != null) {
            return this.booleanValue;
        }
        if (this.varcharValue != null) {
            if (this.varcharValue.equals("0")) {
                return false;
            }
            if (this.varcharValue.equals("1")) {
                return true;
            }
        }
        if (this.integerValue != null) {
            if (this.integerValue == 0) {
                return false;
            }
            if (this.integerValue == 1) {
                return true;
            }
        }
        if (this.bigintValue != null) {
            if (this.bigintValue == 0L) {
                return false;
            }
            if (this.bigintValue == 1L) {
                return true;
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type BOOLEAN.");
    }

    @Override
    public byte asByte() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.integerValue != null) {
            return this.integerValue.byteValue();
        }
        if (this.bigintValue != null) {
            return this.bigintValue.byteValue();
        }
        if (this.isNull()) {
            return 0;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TINYINT, SMALLINT, INTEGER or BIGINT.");
    }

    @Override
    public short asShort() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.integerValue != null) {
            return this.integerValue.shortValue();
        }
        if (this.bigintValue != null) {
            return this.bigintValue.shortValue();
        }
        if (this.isNull()) {
            return 0;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TINYINT, SMALLINT, INTEGER or BIGINT.");
    }

    @Override
    public int asInt() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.integerValue != null) {
            return this.integerValue;
        }
        if (this.bigintValue != null) {
            return this.bigintValue.intValue();
        }
        if (this.bigDecimalValue != null) {
            return this.bigDecimalValue.intValue();
        }
        if (this.isNull()) {
            return 0;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TINYINT, SMALLINT, INTEGER, BIGINT or DECIMAL.");
    }

    @Override
    public long asLong() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.bigintValue != null) {
            return this.bigintValue;
        }
        if (this.integerValue != null) {
            return this.integerValue.intValue();
        }
        if (this.bigDecimalValue != null) {
            return this.bigDecimalValue.longValue();
        }
        if (this.isNull()) {
            return 0L;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TINYINT, SMALLINT, INTEGER, BIGINT or DECIMAL.");
    }

    @Override
    public float asFloat() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.floatValue != null) {
            return this.floatValue.floatValue();
        }
        if (this.doubleValue != null) {
            return this.doubleValue.floatValue();
        }
        if (this.bigDecimalValue != null) {
            return this.bigDecimalValue.floatValue();
        }
        if (this.isNull()) {
            return 0.0f;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type REAL, FLOT or DOUBLE.");
    }

    @Override
    public double asDouble() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        if (this.floatValue != null) {
            return this.floatValue.doubleValue();
        }
        if (this.bigDecimalValue != null) {
            return this.bigDecimalValue.doubleValue();
        }
        if (this.isNull()) {
            return 0.0;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type REAL, FLOT or DOUBLE.");
    }

    @Override
    public BigDecimal asBigDecimal() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.bigDecimalValue != null) {
            return this.bigDecimalValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type DECIMAL.");
    }

    @Override
    @Deprecated
    public BigDecimal asBigDecimal(int scale) throws SQLException {
        return this.asBigDecimal().setScale(scale, RoundingMode.HALF_EVEN);
    }

    @Override
    public byte[] asBytes() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.binaryValue != null) {
            return this.binaryValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type BINARY or VARBINARY.");
    }

    @Override
    public InputStream asAsciiStream() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return new ByteArrayInputStream(this.varcharValue.getBytes(StandardCharsets.US_ASCII));
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type CHAR or VARCHAR.");
    }

    @Override
    @Deprecated
    public InputStream asUnicodeStream() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return new ByteArrayInputStream(this.varcharValue.getBytes(StandardCharsets.UTF_8));
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type CHAR or VARCHAR.");
    }

    @Override
    public InputStream asBinaryStream() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.blobValue != null) {
            return this.blobValue.getBinaryStream();
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not streamable.");
    }

    @Override
    public PolyDocument asDocument() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.otherValue != null) {
            return (PolyDocument)this.otherValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type DOCUMENT.");
    }

    @Override
    public PolyInterval asInterval() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.otherValue != null) {
            return (PolyInterval)this.otherValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type INTERVAL.");
    }

    @Override
    public Object asObject() throws SQLException {
        switch (this.valueCase) {
            case BOOLEAN: {
                return this.asBoolean();
            }
            case INTEGER: {
                return this.asInt();
            }
            case LONG: {
                return this.asLong();
            }
            case BIG_DECIMAL: {
                return this.asBigDecimal();
            }
            case FLOAT: {
                return Float.valueOf(this.asFloat());
            }
            case DOUBLE: {
                return this.asDouble();
            }
            case DATE: {
                return this.asDate();
            }
            case TIME: {
                return this.asTime();
            }
            case TIMESTAMP: {
                return this.asTimestamp();
            }
            case INTERVAL: {
                return this.asInterval();
            }
            case STRING: {
                return this.asString();
            }
            case BINARY: {
                return this.asBytes();
            }
            case NULL: {
                return null;
            }
            case LIST: {
                return this.asArray();
            }
            case DOCUMENT: {
                return this.asDocument();
            }
            case FILE: {
                return this.asBlob();
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value has unknown type and thus can not be returned.");
    }

    @Override
    public Object asObject(Calendar calendar) throws SQLException {
        switch (this.valueCase) {
            case BOOLEAN: {
                return this.asBoolean();
            }
            case INTEGER: {
                return this.asInt();
            }
            case LONG: {
                return this.asLong();
            }
            case BIG_DECIMAL: {
                return this.asBigDecimal();
            }
            case FLOAT: {
                return Float.valueOf(this.asFloat());
            }
            case DOUBLE: {
                return this.asDouble();
            }
            case DATE: {
                return this.asDate(calendar);
            }
            case TIME: {
                return this.asTime(calendar);
            }
            case TIMESTAMP: {
                return this.asTimestamp(calendar);
            }
            case INTERVAL: {
                return this.asInterval();
            }
            case STRING: {
                return this.asString();
            }
            case BINARY: {
                return this.asBytes();
            }
            case NULL: {
                return null;
            }
            case LIST: {
                return this.asArray();
            }
            case DOCUMENT: {
                return this.asDocument();
            }
            case FILE: {
                return this.asBlob();
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value has unknown type and thus can not be returned.");
    }

    @Override
    public Reader asCharacterStream() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return new StringReader(this.varcharValue);
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type CHAR or VARCHAR.");
    }

    @Override
    public Blob asBlob() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.blobValue != null) {
            return this.blobValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type FILE, AUDIO, VIDEO or IMAGE.");
    }

    @Override
    public Clob asClob() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return new PolyClob(this.varcharValue);
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type CHAR or VARCHAR.");
    }

    @Override
    public Array asArray() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.arrayValue != null) {
            return this.arrayValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type ARRAY.");
    }

    @Override
    public Struct asStruct() throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "No type retrievable as a struct exists in Polypheny.");
    }

    @Override
    public Date asDate() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.dateValue != null) {
            return this.dateValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type DATE.");
    }

    @Override
    public Date asDate(Calendar calendar) throws SQLException {
        return TypedValueUtils.getDateInCalendar(this.asDate(), calendar);
    }

    @Override
    public Time asTime() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.timeValue != null) {
            return this.timeValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TIME.");
    }

    @Override
    public Time asTime(Calendar calendar) throws SQLException {
        return TypedValueUtils.getTimeInCalendar(this.asTime(), calendar);
    }

    @Override
    public Timestamp asTimestamp() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.timestampValue != null) {
            return this.timestampValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type TIMESTAMP.");
    }

    @Override
    public Timestamp asTimestamp(Calendar calendar) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return TypedValueUtils.getTimestampInCalendar(this.asTimestamp(), calendar);
    }

    @Override
    public Ref asRef() throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "No type retrievable as a reference exists in Polypheny.");
    }

    @Override
    public RowId asRowId() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.rowIdValue != null) {
            return this.rowIdValue;
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type ROW_ID.");
    }

    @Override
    public URL asUrl() throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "No type retrievable as a url exists in Polypheny.");
    }

    @Override
    public NClob asNClob() throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.varcharValue != null) {
            return new PolyClob(this.varcharValue);
        }
        if (this.isNull()) {
            return null;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type FILE, AUDIO, VIDEO or IMAGE.");
    }

    @Override
    public SQLXML asSQLXML() throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "No type retrievable as SQLXML exists in Polypheny.");
    }

    @Override
    public String asNString() throws SQLException {
        return this.asString();
    }

    @Override
    public Reader asNCharacterStream() throws SQLException {
        return this.asCharacterStream();
    }

    @Override
    public Object asObject(Map<String, Class<?>> map) throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.otherValue == null || !(this.otherValue instanceof UDTPrototype)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type USER_DEFINED_TYPE.");
        }
        UDTPrototype prototype = (UDTPrototype)this.otherValue;
        Class<?> udtClass = map.get(prototype.getTypeName());
        return this.buildFromUdtPrototype(udtClass, prototype);
    }

    @Override
    public <T> T asObject(Class<T> aClass) throws SQLException {
        if (this.isSerialized) {
            this.deserialize();
        }
        if (this.otherValue == null || !(this.otherValue instanceof UDTPrototype)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "This value is not of type USER_DEFINED_TYPE.");
        }
        return aClass.cast(this.buildFromUdtPrototype(aClass, (UDTPrototype)this.otherValue));
    }

    private <T> Object buildFromUdtPrototype(Class<T> udtClass, UDTPrototype prototype) throws SQLException {
        if (udtClass == null) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "Type-map contains no type for internal type " + prototype.getTypeName());
        }
        try {
            Constructor<T> udtConstructor = udtClass.getConstructor(SQLInput.class, String.class);
            return udtConstructor.newInstance(prototype, prototype.getTypeName());
        }
        catch (NoSuchMethodException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.MISSING_INTERFACE, "The type contained in the type map does not implement the SQLInput interface required for udt construction");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.UDT_CONSTRUCTION_FAILED, "Construction of user defined type failed", (Throwable)e);
        }
    }

    private static byte[] collectByteStream(InputStream stream) throws IOException {
        int frameLength;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] frame = new byte[4];
        while ((frameLength = stream.read(frame, 0, frame.length)) != -1) {
            buffer.write(frame, 0, frameLength);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static String collectCharacterStream(Reader reader) throws IOException {
        int bufferIndex;
        char[] readBuffer = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((bufferIndex = reader.read(readBuffer, 0, readBuffer.length)) != -1) {
            buffer.append(readBuffer, 0, bufferIndex);
        }
        reader.close();
        return buffer.toString();
    }

    private void deserialize() {
        try {
            switch (this.valueCase) {
                case BOOLEAN: {
                    this.booleanValue = this.serialized.getBoolean().getBoolean();
                    break;
                }
                case INTEGER: {
                    this.integerValue = this.serialized.getInteger().getInteger();
                    break;
                }
                case LONG: {
                    this.bigintValue = this.serialized.getLong().getLong();
                    break;
                }
                case BINARY: {
                    this.binaryValue = this.serialized.getBinary().getBinary().toByteArray();
                    break;
                }
                case DATE: {
                    this.dateValue = new Date(this.serialized.getDate().getDate() * 86400000L);
                    break;
                }
                case DOUBLE: {
                    this.doubleValue = this.serialized.getDouble().getDouble();
                    break;
                }
                case FLOAT: {
                    this.floatValue = Float.valueOf(this.serialized.getFloat().getFloat());
                    break;
                }
                case NULL: {
                    break;
                }
                case STRING: {
                    this.varcharValue = this.serialized.getString().getString();
                    break;
                }
                case TIME: {
                    this.timeValue = new Time(this.serialized.getTime().getTime());
                    break;
                }
                case TIMESTAMP: {
                    this.timestampValue = new Timestamp(this.serialized.getTimestamp().getTimestamp());
                    break;
                }
                case BIG_DECIMAL: {
                    this.bigDecimalValue = TypedValue.getBigDecimal(this.serialized.getBigDecimal().getUnscaledValue(), this.serialized.getBigDecimal().getScale());
                    break;
                }
                case LIST: {
                    this.arrayValue = TypedValue.getArray(this.serialized);
                    break;
                }
                case INTERVAL: {
                    this.otherValue = TypedValue.getInterval(this.serialized.getInterval());
                    break;
                }
                case DOCUMENT: {
                    this.otherValue = new PolyDocument(this.serialized.getDocument());
                    break;
                }
                case FILE: {
                    this.blobValue = new PolyBlob(this.serialized.getFile().getBinary().toByteArray());
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot deserialize ProtoValue of case " + this.valueCase);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ProtoValue serialize() throws SQLException {
        switch (this.valueCase) {
            case BOOLEAN: {
                return this.serializeAsProtoBoolean();
            }
            case INTEGER: {
                return this.serializeAsProtoInteger();
            }
            case LONG: {
                return this.serializeAsProtoLong();
            }
            case BIG_DECIMAL: {
                return this.serializeAsProtoBigDecimal();
            }
            case FLOAT: {
                return this.serializeAsProtoFloat();
            }
            case DOUBLE: {
                return this.serializeAsProtoDouble();
            }
            case DATE: {
                return this.serializeAsProtoDate();
            }
            case TIME: {
                return this.serializeAsProtoTime();
            }
            case TIMESTAMP: {
                return this.serializeAsTimestamp();
            }
            case INTERVAL: {
                return this.serializeAsInterval();
            }
            case STRING: {
                return this.serializeAsProtoString();
            }
            case BINARY: {
                return this.serializeAsProtoBinary();
            }
            case NULL: {
                return this.serializeAsProtoNull();
            }
            case LIST: {
                return this.serializeAsProtoList();
            }
            case FILE: {
                return this.serializeAsProtoFile();
            }
            case DOCUMENT: {
                return this.serializeAsProtoDocument();
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.DATA_TYPE_MISMATCH, "Failed to serialize unknown type: " + this.valueCase.name());
    }

    private ProtoValue serializeAsProtoFile() throws SQLException {
        try {
            ProtoFile protoFile = ProtoFile.newBuilder().setBinary(ByteString.copyFrom(TypedValue.collectByteStream(this.blobValue.getBinaryStream()))).build();
            return ProtoValue.newBuilder().setFile(protoFile).build();
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Failed to read bytes from blob.");
        }
    }

    private ProtoValue serializeAsProtoDocument() {
        return ProtoValue.newBuilder().setDocument(((PolyDocument)this.otherValue).serialize()).build();
    }

    private ProtoValue serializeAsInterval() {
        PolyInterval interval = (PolyInterval)this.otherValue;
        ProtoInterval protoInterval = ProtoInterval.newBuilder().setMonths(interval.getMonths()).setMilliseconds(interval.getMilliseconds()).build();
        return ProtoValue.newBuilder().setInterval(protoInterval).build();
    }

    private ProtoValue serializeAsProtoList() throws SQLException {
        ArrayList<ProtoValue> elements = new ArrayList<ProtoValue>();
        for (Object object : (Object[])this.arrayValue.getArray()) {
            elements.add(TypedValue.fromObject(object).serialize());
        }
        ProtoList protoList = ProtoList.newBuilder().addAllValues(elements).build();
        return ProtoValue.newBuilder().setList(protoList).build();
    }

    private ProtoValue serializeAsProtoDouble() {
        ProtoDouble protoDouble = ProtoDouble.newBuilder().setDouble(this.doubleValue).build();
        return ProtoValue.newBuilder().setDouble(protoDouble).build();
    }

    private ProtoValue serializeAsProtoFloat() {
        ProtoFloat protoFloat = ProtoFloat.newBuilder().setFloat(this.floatValue.floatValue()).build();
        return ProtoValue.newBuilder().setFloat(protoFloat).build();
    }

    private ProtoValue serializeAsProtoLong() {
        ProtoLong protoLong = ProtoLong.newBuilder().setLong(this.bigintValue).build();
        return ProtoValue.newBuilder().setLong(protoLong).build();
    }

    private ProtoValue serializeAsProtoBigDecimal() {
        ProtoBigDecimal protoBigDecimal = ProtoBigDecimal.newBuilder().setUnscaledValue(ByteString.copyFrom(this.bigDecimalValue.unscaledValue().toByteArray())).setScale(this.bigDecimalValue.scale()).build();
        return ProtoValue.newBuilder().setBigDecimal(protoBigDecimal).build();
    }

    private ProtoValue serializeAsProtoDate() {
        long milliseconds = this.dateValue.getTime();
        milliseconds += (long)DriverProperties.getDEFAULT_TIMEZONE().getOffset(milliseconds);
        ProtoDate protoDate = ProtoDate.newBuilder().setDate(milliseconds / 86400000L).build();
        return ProtoValue.newBuilder().setDate(protoDate).build();
    }

    private ProtoValue serializeAsProtoString() {
        return ProtoUtils.serializeAsProtoString(this.varcharValue);
    }

    private ProtoValue serializeAsProtoTime() {
        long ofDay = this.timeValue.getTime();
        ofDay += (long)DriverProperties.getDEFAULT_TIMEZONE().getOffset(ofDay);
        ProtoTime protoTime = ProtoTime.newBuilder().setTime((int)ofDay).build();
        return ProtoValue.newBuilder().setTime(protoTime).build();
    }

    private ProtoValue serializeAsTimestamp() {
        long milliseconds = this.timestampValue.getTime();
        milliseconds += (long)DriverProperties.getDEFAULT_TIMEZONE().getOffset(milliseconds);
        ProtoTimestamp protoTimestamp = ProtoTimestamp.newBuilder().setTimestamp(milliseconds).build();
        return ProtoValue.newBuilder().setTimestamp(protoTimestamp).build();
    }

    private ProtoValue serializeAsProtoBinary() {
        ProtoBinary protoBinary = ProtoBinary.newBuilder().setBinary(ByteString.copyFrom(this.binaryValue)).build();
        return ProtoValue.newBuilder().setBinary(protoBinary).build();
    }

    private ProtoValue serializeAsProtoNull() {
        return ProtoValue.newBuilder().setNull(ProtoNull.newBuilder().build()).build();
    }

    private ProtoValue serializeAsProtoBoolean() {
        ProtoBoolean protoBoolean = ProtoBoolean.newBuilder().setBoolean(this.booleanValue).build();
        return ProtoValue.newBuilder().setBoolean(protoBoolean).build();
    }

    private ProtoValue serializeAsProtoInteger() {
        ProtoInteger protoInteger = ProtoInteger.newBuilder().setInteger(this.integerValue).build();
        return ProtoValue.newBuilder().setInteger(protoInteger).build();
    }

    private static BigDecimal getBigDecimal(ByteString unscaledValue, int scale) {
        BigInteger value = new BigInteger(unscaledValue.toByteArray());
        return new BigDecimal(value, scale);
    }

    private static Array getArray(ProtoValue value) throws SQLException {
        String baseType = value.getValueCase().name();
        List<TypedValue> values = value.getList().getValuesList().stream().map(TypedValue::new).collect(Collectors.toList());
        return new PolyArray(baseType, values);
    }

    private static PolyInterval getInterval(ProtoInterval interval) {
        return new PolyInterval(interval.getMonths(), interval.getMilliseconds());
    }

    public String toString() {
        try {
            return this.asString();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public ProtoValue.ValueCase getValueCase() {
        return this.valueCase;
    }
}

