/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.types.TypedValue;

public class UDTPrototype
implements SQLInput {
    private final String typeName;
    private final ArrayList<TypedValue> values;
    private int currentIndex;
    private boolean lastValueWasNull;
    private boolean isFinalized;

    public UDTPrototype(String typeName, ArrayList<TypedValue> values) {
        this.typeName = typeName;
        this.values = values;
        this.currentIndex = -1;
        this.lastValueWasNull = true;
        this.isFinalized = false;
    }

    public UDTPrototype(String typeName) {
        this.typeName = typeName;
        this.values = new ArrayList();
        this.currentIndex = -1;
        this.lastValueWasNull = true;
        this.isFinalized = false;
    }

    public void addValue(TypedValue value) throws SQLException {
        if (this.isFinalized) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Can't add values to finalized prototype.");
        }
        this.values.add(value);
    }

    private TypedValue getNextValue() throws SQLException {
        if (!this.isFinalized) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Can't read value from unfinalized prototype.");
        }
        ++this.currentIndex;
        if (this.currentIndex >= this.values.size()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.UDT_REACHED_END, "Reached end of udt value stream.");
        }
        TypedValue currentValue = this.values.get(this.currentIndex);
        this.lastValueWasNull = currentValue.isNull();
        return currentValue;
    }

    @Override
    public String readString() throws SQLException {
        return this.getNextValue().asString();
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return this.getNextValue().asBoolean();
    }

    @Override
    public byte readByte() throws SQLException {
        return this.getNextValue().asByte();
    }

    @Override
    public short readShort() throws SQLException {
        return this.getNextValue().asShort();
    }

    @Override
    public int readInt() throws SQLException {
        return this.getNextValue().asInt();
    }

    @Override
    public long readLong() throws SQLException {
        return this.getNextValue().asLong();
    }

    @Override
    public float readFloat() throws SQLException {
        return this.getNextValue().asFloat();
    }

    @Override
    public double readDouble() throws SQLException {
        return this.getNextValue().asDouble();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.getNextValue().asBigDecimal();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.getNextValue().asBytes();
    }

    @Override
    public Date readDate() throws SQLException {
        return this.getNextValue().asDate();
    }

    @Override
    public Time readTime() throws SQLException {
        return this.getNextValue().asTime();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.getNextValue().asTimestamp();
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return this.getNextValue().asCharacterStream();
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return this.getNextValue().asAsciiStream();
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return this.getNextValue().asBinaryStream();
    }

    @Override
    public Object readObject() throws SQLException {
        return this.getNextValue().asObject();
    }

    @Override
    public Ref readRef() throws SQLException {
        return this.getNextValue().asRef();
    }

    @Override
    public Blob readBlob() throws SQLException {
        return this.getNextValue().asBlob();
    }

    @Override
    public Clob readClob() throws SQLException {
        return this.getNextValue().asClob();
    }

    @Override
    public Array readArray() throws SQLException {
        return this.getNextValue().asArray();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        return this.getNextValue().asUrl();
    }

    @Override
    public NClob readNClob() throws SQLException {
        return this.getNextValue().asNClob();
    }

    @Override
    public String readNString() throws SQLException {
        return this.getNextValue().asNString();
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return this.getNextValue().asSQLXML();
    }

    @Override
    public RowId readRowId() throws SQLException {
        return this.getNextValue().asRowId();
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }
}

