/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.utils;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Response;

public class CallbackQueue<T> {
    private final Lock queueLock = new ReentrantLock();
    private final Condition hasNext = this.queueLock.newCondition();
    private final Condition isCompleted = this.queueLock.newCondition();
    private boolean bIsCompleted = false;
    private final Queue<T> messageQueue = new LinkedList<T>();
    private final Function<Response, T> extractResponse;
    private PrismInterfaceServiceException propagatedException;

    public CallbackQueue(Function<Response, T> extractResponse) {
        this.extractResponse = extractResponse;
    }

    public void awaitCompletion() throws InterruptedException {
        this.queueLock.lock();
        while (!this.bIsCompleted) {
            this.isCompleted.await();
        }
    }

    public T takeNext() throws PrismInterfaceServiceException {
        this.queueLock.lock();
        while (this.messageQueue.isEmpty()) {
            try {
                this.hasNext.await();
            }
            catch (InterruptedException e) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting next response failed.", (Throwable)e);
            }
            this.throwReceivedException();
        }
        T message = this.messageQueue.remove();
        this.queueLock.unlock();
        return message;
    }

    private void throwReceivedException() throws PrismInterfaceServiceException {
        if (this.propagatedException != null) {
            throw this.propagatedException;
        }
    }

    public void onNext(Response message) {
        this.queueLock.lock();
        this.messageQueue.add(this.extractResponse.apply(message));
        this.hasNext.signal();
        this.queueLock.unlock();
    }

    public void onError(Throwable propagatedException) {
        this.queueLock.lock();
        this.propagatedException = new PrismInterfaceServiceException(propagatedException);
        this.hasNext.signal();
        this.queueLock.unlock();
    }

    public void onCompleted() {
        this.queueLock.lock();
        this.bIsCompleted = true;
        this.isCompleted.signal();
        this.queueLock.unlock();
    }
}

