/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.utils;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.polypheny.jdbc.dependency.prism.ProtoString;
import org.polypheny.jdbc.dependency.prism.ProtoValue;
import org.polypheny.jdbc.types.TypedValue;

public class ProtoUtils {
    public static ProtoValue serializeAsProtoString(String string) {
        ProtoString protoString = ProtoString.newBuilder().setString(string).build();
        return ProtoValue.newBuilder().setString(protoString).build();
    }

    public static List<ProtoValue> serializeParameterList(List<TypedValue> values) {
        return values.stream().map(v -> {
            try {
                return v.serialize();
            }
            catch (SQLException e) {
                throw new RuntimeException("Should not be thrown. Encountered an unknown type during serialization.");
            }
        }).collect(Collectors.toList());
    }
}

