/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.polypheny.jdbc.dependency.prism.ProtoPolyType;
import org.polypheny.jdbc.dependency.prism.Row;
import org.polypheny.jdbc.types.PolyDocument;
import org.polypheny.jdbc.types.PolyInterval;
import org.polypheny.jdbc.types.ProtoToJdbcTypeMap;
import org.polypheny.jdbc.types.TypedValue;

public class TypedValueUtils {
    private static SimpleDateFormat SQL_DATE_FORMAT;
    private static SimpleDateFormat SQL_TIME_FORMAT;

    public static Time getTimeFromString(String string) throws ParseException {
        return new Time(SQL_TIME_FORMAT.parse(string).getTime());
    }

    public static Date getDateFromString(String string) throws ParseException {
        return Date.valueOf(string);
    }

    public static boolean getBooleanFromNumber(Number number) {
        return number.byteValue() == 1;
    }

    public static boolean getBooleanFromString(String string) {
        return string.equals("1") || string.equalsIgnoreCase("true");
    }

    public static Number getNumberFromBoolean(Boolean bool) {
        if (bool.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static String getOneZeroStringFromBoolean(Boolean bool) {
        if (bool.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public static Date getDateFromTimestamp(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    public static Date getDateInCalendar(Date date, Calendar calendar) {
        return new Date(TypedValueUtils.getTimeLongInCalendar(date.getTime(), calendar));
    }

    public static Time getTimeFromTimestamp(Timestamp timestamp) {
        return new Time(timestamp.getTime());
    }

    public static Time getTimeInCalendar(Time time, Calendar calendar) {
        return new Time(TypedValueUtils.getTimeLongInCalendar(time.getTime(), calendar));
    }

    private static Time getTimeFromOffsetTime(OffsetTime offsetTime) {
        return Time.valueOf(offsetTime.toLocalTime());
    }

    private static Timestamp getTimestampFromOffsetDateTime(OffsetDateTime offsetDateTime) {
        return Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
    }

    public static Timestamp getTimestampFromTime(Time value) {
        return new Timestamp(value.getTime());
    }

    public static Timestamp getTimestampFromDate(Date value) {
        return new Timestamp(value.getTime());
    }

    public static Timestamp getTimestampFromString(String value) {
        return Timestamp.valueOf(value);
    }

    public static Timestamp getTimestampInCalendar(Timestamp timestamp, Calendar calendar) {
        return new Timestamp(TypedValueUtils.getTimeLongInCalendar(timestamp.getTime(), calendar));
    }

    private static long getTimeLongInCalendar(long value, Calendar calendar) {
        if (calendar == null) {
            return value - (long)Calendar.getInstance().getTimeZone().getOffset(value);
        }
        return value - (long)calendar.getTimeZone().getOffset(value);
    }

    public static List<List<TypedValue>> buildRows(List<Row> rows) {
        return rows.stream().map(TypedValueUtils::buildRow).collect(Collectors.toList());
    }

    public static List<TypedValue> buildRow(Row row) {
        return row.getValuesList().stream().map(TypedValue::new).collect(Collectors.toList());
    }

    public static int getJdbcTypeFromPolyTypeName(String polyTypeName) {
        return ProtoToJdbcTypeMap.getJdbcTypeFromProto(ProtoPolyType.valueOf(polyTypeName));
    }

    public static TypedValue buildTypedValueFromObject(Object value) throws SQLException, ParseException {
        if (value == null) {
            return TypedValue.fromNull();
        }
        if (value instanceof String) {
            return TypedValueUtils.buildTypedValueFromObject(value, 12);
        }
        if (value instanceof BigDecimal) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2);
        }
        if (value instanceof Boolean) {
            return TypedValueUtils.buildTypedValueFromObject(value, 16);
        }
        if (value instanceof Byte) {
            return TypedValueUtils.buildTypedValueFromObject(value, -6);
        }
        if (value instanceof Short) {
            return TypedValueUtils.buildTypedValueFromObject(value, 5);
        }
        if (value instanceof Integer) {
            return TypedValueUtils.buildTypedValueFromObject(value, 4);
        }
        if (value instanceof Long) {
            return TypedValueUtils.buildTypedValueFromObject(value, -5);
        }
        if (value instanceof Float) {
            return TypedValueUtils.buildTypedValueFromObject(value, 7);
        }
        if (value instanceof Double) {
            return TypedValueUtils.buildTypedValueFromObject(value, 8);
        }
        if (value instanceof byte[]) {
            return TypedValueUtils.buildTypedValueFromObject(value, -2);
        }
        if (value instanceof BigInteger) {
            return TypedValueUtils.buildTypedValueFromObject(value, -5);
        }
        if (value instanceof Date) {
            return TypedValueUtils.buildTypedValueFromObject(value, 91);
        }
        if (value instanceof Time) {
            return TypedValueUtils.buildTypedValueFromObject(value, 92);
        }
        if (value instanceof Timestamp) {
            return TypedValueUtils.buildTypedValueFromObject(value, 93);
        }
        if (value instanceof NClob) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2011);
        }
        if (value instanceof Clob) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2005);
        }
        if (value instanceof Blob) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2004);
        }
        if (value instanceof Array) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2003);
        }
        if (value instanceof Struct) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2002);
        }
        if (value instanceof Ref) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2006);
        }
        if (value instanceof URL) {
            return TypedValueUtils.buildTypedValueFromObject(value, 70);
        }
        if (value instanceof RowId) {
            return TypedValueUtils.buildTypedValueFromObject(value, -8);
        }
        if (value instanceof SQLXML) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2009);
        }
        if (value instanceof Calendar) {
            return TypedValueUtils.buildTypedValueFromObject(value, 93);
        }
        if (value instanceof java.util.Date) {
            return TypedValueUtils.buildTypedValueFromObject(value, 93);
        }
        if (value instanceof LocalDate) {
            return TypedValueUtils.buildTypedValueFromObject(value, 91);
        }
        if (value instanceof LocalTime) {
            return TypedValueUtils.buildTypedValueFromObject(value, 92);
        }
        if (value instanceof LocalDateTime) {
            return TypedValueUtils.buildTypedValueFromObject(value, 93);
        }
        if (value instanceof OffsetTime) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2013);
        }
        if (value instanceof OffsetDateTime) {
            return TypedValueUtils.buildTypedValueFromObject(value, 2014);
        }
        if (value instanceof PolyInterval) {
            return TypedValue.fromInterval((PolyInterval)value);
        }
        if (value instanceof PolyDocument) {
            return TypedValue.fromDocument((PolyDocument)value);
        }
        return TypedValueUtils.buildTypedValueFromObject(value, 2000);
    }

    public static TypedValue buildTypedValueFromObject(Object value, int targetSqlType) throws ParseException, SQLException {
        if (value == null) {
            return TypedValue.fromNull();
        }
        if (value instanceof String) {
            return TypedValueUtils.buildTypedValueFromString((String)value, targetSqlType);
        }
        if (value instanceof BigDecimal) {
            return TypedValueUtils.buildTypedValueFromBigDecimal((BigDecimal)value, targetSqlType);
        }
        if (value instanceof Boolean) {
            return TypedValueUtils.buildTypedValueFromBoolean((Boolean)value, targetSqlType);
        }
        if (value instanceof Byte) {
            return TypedValueUtils.buildTypedValueFromByte((Byte)value, targetSqlType);
        }
        if (value instanceof Short) {
            return TypedValueUtils.buildTypedValueFromShort((Short)value, targetSqlType);
        }
        if (value instanceof Integer) {
            return TypedValueUtils.buildTypedValueFromInteger((Integer)value, targetSqlType);
        }
        if (value instanceof Long) {
            return TypedValueUtils.buildTypedValueFromLong((Long)value, targetSqlType);
        }
        if (value instanceof Float) {
            return TypedValueUtils.buildTypedValueFromFloat((Float)value, targetSqlType);
        }
        if (value instanceof Double) {
            return TypedValueUtils.buildTypedValueFromDouble((Double)value, targetSqlType);
        }
        if (value instanceof byte[]) {
            return TypedValueUtils.buildTypedValueFromBytes((byte[])value, targetSqlType);
        }
        if (value instanceof BigInteger) {
            return TypedValueUtils.buildTypedValueFromBigInteger((BigInteger)value, targetSqlType);
        }
        if (value instanceof Date) {
            return TypedValueUtils.buildTypedValueFromDate((Date)value, targetSqlType);
        }
        if (value instanceof Time) {
            return TypedValueUtils.buildTypedValueFromTime((Time)value, targetSqlType);
        }
        if (value instanceof Timestamp) {
            return TypedValueUtils.buildTypedValueFromTimestamp((Timestamp)value, targetSqlType);
        }
        if (value instanceof NClob) {
            return TypedValueUtils.buildTypedValueFromNClob((NClob)value, targetSqlType);
        }
        if (value instanceof Clob) {
            return TypedValueUtils.buildTypedValueFromClob((Clob)value, targetSqlType);
        }
        if (value instanceof Blob) {
            return TypedValueUtils.buildTypedValueFromBlob((Blob)value, targetSqlType);
        }
        if (value instanceof Array) {
            return TypedValueUtils.buildTypedValueFromArray((Array)value, targetSqlType);
        }
        if (value instanceof Struct) {
            return TypedValueUtils.buildTypedValueFromStruct((Struct)value, targetSqlType);
        }
        if (value instanceof Ref) {
            return TypedValueUtils.buildTypedValueFromRef((Ref)value, targetSqlType);
        }
        if (value instanceof URL) {
            return TypedValueUtils.buildTypedValueFromURL((URL)value, targetSqlType);
        }
        if (value instanceof RowId) {
            return TypedValueUtils.buildTypedValueFromRowId((RowId)value, targetSqlType);
        }
        if (value instanceof SQLXML) {
            return TypedValueUtils.buildTypedValueFromSQXML((SQLXML)value, targetSqlType);
        }
        if (value instanceof Calendar) {
            return TypedValueUtils.buildTypedValueFromCalendar((Calendar)value, targetSqlType);
        }
        if (value instanceof java.util.Date) {
            return TypedValueUtils.buildTypedValueFromDate((java.util.Date)value, targetSqlType);
        }
        if (value instanceof LocalDate) {
            return TypedValueUtils.buildTypedValueFromLocalDate((LocalDate)value, targetSqlType);
        }
        if (value instanceof LocalTime) {
            return TypedValueUtils.buildTypedValueFromLocalTime((LocalTime)value, targetSqlType);
        }
        if (value instanceof LocalDateTime) {
            return TypedValueUtils.buildTypedValueFromLocalDateTime((LocalDateTime)value, targetSqlType);
        }
        if (value instanceof OffsetTime) {
            return TypedValueUtils.buildTypedValueFromOffsetTime((OffsetTime)value, targetSqlType);
        }
        if (value instanceof OffsetDateTime) {
            return TypedValueUtils.buildTypedValueFromOffsetDateTime((OffsetDateTime)value, targetSqlType);
        }
        if (value instanceof PolyInterval) {
            return TypedValue.fromInterval((PolyInterval)value);
        }
        if (value instanceof PolyDocument) {
            return TypedValue.fromDocument((PolyDocument)value);
        }
        return TypedValueUtils.buildTypedValueFromJavaObject(value, targetSqlType);
    }

    private static TypedValue buildTypedValueFromJavaObject(Object value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 2000) {
            throw new ParseException("Can't parse Object as type " + targetSqlType, 0);
        }
        return TypedValue.fromObject(value);
    }

    private static TypedValue buildTypedValueFromOffsetDateTime(OffsetDateTime value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 2014: {
                return TypedValue.fromTimestamp(TypedValueUtils.getTimestampFromOffsetDateTime(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse OffsetDateTime as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromOffsetTime(OffsetTime value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 2013: {
                return TypedValue.fromTime(TypedValueUtils.getTimeFromOffsetTime(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse OffsetTime as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromLocalDateTime(LocalDateTime value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(Time.valueOf(value.toLocalTime()));
            }
            case 91: {
                return TypedValue.fromDate(Date.valueOf(value.toLocalDate()));
            }
            case 93: {
                return TypedValue.fromTimestamp(Timestamp.valueOf(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse LocalDateTime as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromLocalTime(LocalTime value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(Time.valueOf(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse LocalTime as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromLocalDate(LocalDate value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 91: {
                return TypedValue.fromDate(Date.valueOf(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse LocalTime as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromDate(java.util.Date value, int targetSqlType) throws ParseException, SQLFeatureNotSupportedException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(new Time(value.getTime()));
            }
            case 91: {
                return TypedValue.fromDate(new Date(value.getTime()));
            }
            case 93: {
                return TypedValue.fromTimestamp(new Timestamp(value.getTime()));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
            case 2003: {
                throw new SQLFeatureNotSupportedException("Parsing of Date as an Array is not supported");
            }
        }
        throw new ParseException("Can't parse Date as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromCalendar(Calendar value, int targetSqlType) throws ParseException, SQLFeatureNotSupportedException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(new Time(value.getTimeInMillis()));
            }
            case 91: {
                return TypedValue.fromDate(new Date(value.getTimeInMillis()));
            }
            case 93: {
                return TypedValue.fromTimestamp(new Timestamp(value.getTimeInMillis()));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
            case 2003: {
                throw new SQLFeatureNotSupportedException("Parsing of Calendar as an Array is not supported");
            }
        }
        throw new ParseException("Can't parse Calendar as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromSQXML(SQLXML value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 2009) {
            throw new ParseException("Can't parse SQLXML as type " + targetSqlType, 0);
        }
        return TypedValue.fromSQLXML(value);
    }

    private static TypedValue buildTypedValueFromRowId(RowId value, int targetSqlType) throws ParseException, SQLFeatureNotSupportedException {
        if (targetSqlType != -8) {
            throw new ParseException("Can't parse RowId as type " + targetSqlType, 0);
        }
        return TypedValue.fromRowId(value);
    }

    private static TypedValue buildTypedValueFromURL(URL value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 70) {
            throw new ParseException("Can't parse URL as type " + targetSqlType, 0);
        }
        return TypedValue.fromUrl(value);
    }

    private static TypedValue buildTypedValueFromRef(Ref value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 2006) {
            throw new ParseException("Can't parse Ref as type " + targetSqlType, 0);
        }
        return TypedValue.fromRef(value);
    }

    private static TypedValue buildTypedValueFromStruct(Struct value, int targetSqlType) throws ParseException, SQLFeatureNotSupportedException {
        if (targetSqlType != 2002) {
            throw new ParseException("Can't parse Struct as type " + targetSqlType, 0);
        }
        return TypedValue.fromStruct(value);
    }

    private static TypedValue buildTypedValueFromArray(Array value, int targetSqlType) throws ParseException {
        if (targetSqlType != 2003) {
            throw new ParseException("Can't parse Array as type " + targetSqlType, 0);
        }
        return TypedValue.fromArray(value);
    }

    private static TypedValue buildTypedValueFromBlob(Blob value, int targetSqlType) throws ParseException {
        if (targetSqlType != 2004) {
            throw new ParseException("Can't parse Blob as type " + targetSqlType, 0);
        }
        return TypedValue.fromBlob(value);
    }

    private static TypedValue buildTypedValueFromClob(Clob value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 2005) {
            throw new ParseException("Can't parse Clob as type " + targetSqlType, 0);
        }
        return TypedValue.fromClob(value);
    }

    private static TypedValue buildTypedValueFromNClob(NClob value, int targetSqlType) throws ParseException, SQLException {
        if (targetSqlType != 2011) {
            throw new ParseException("Can't parse NClob as type " + targetSqlType, 0);
        }
        return TypedValue.fromNClob(value);
    }

    private static TypedValue buildTypedValueFromTimestamp(Timestamp value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(TypedValueUtils.getTimeFromTimestamp(value));
            }
            case 91: {
                return TypedValue.fromDate(TypedValueUtils.getDateFromTimestamp(value));
            }
            case 93: {
                return TypedValue.fromTimestamp(value);
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Timestamp as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromTime(Time value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 92: {
                return TypedValue.fromTime(value);
            }
            case 93: {
                return TypedValue.fromTimestamp(TypedValueUtils.getTimestampFromTime(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(SQL_TIME_FORMAT.format(value));
            }
        }
        throw new ParseException("Can't parse Time as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromDate(Date value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case 91: {
                return TypedValue.fromDate(value);
            }
            case 93: {
                return TypedValue.fromTimestamp(TypedValueUtils.getTimestampFromDate(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(SQL_DATE_FORMAT.format(value));
            }
        }
        throw new ParseException("Can't parse Date as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromBigInteger(BigInteger value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -5: {
                return TypedValue.fromLong(value.longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse BigInteger as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromBytes(byte[] value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: {
                return TypedValue.fromBytes(value);
            }
        }
        throw new ParseException("Can't parse byte[] as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromDouble(Double value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value.shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(value.intValue());
            }
            case -5: {
                return TypedValue.fromLong(value.longValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.floatValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value);
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Double as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromFloat(Float value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value.shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(value.intValue());
            }
            case -5: {
                return TypedValue.fromLong(value.longValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.floatValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.floatValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value.floatValue()));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Float as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromLong(Long value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value.shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(value.intValue());
            }
            case -5: {
                return TypedValue.fromLong(value);
            }
            case 7: {
                return TypedValue.fromFloat(value.longValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.longValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Long as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromInteger(Integer value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value.shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(value);
            }
            case -5: {
                return TypedValue.fromLong(value.intValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.intValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.intValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Integer as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromShort(Short value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value);
            }
            case 4: {
                return TypedValue.fromInteger(value.shortValue());
            }
            case -5: {
                return TypedValue.fromLong(value.shortValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.shortValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.shortValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value.shortValue()));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Short as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromByte(Byte value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value);
            }
            case 5: {
                return TypedValue.fromShort(value.byteValue());
            }
            case 4: {
                return TypedValue.fromInteger(value.byteValue());
            }
            case -5: {
                return TypedValue.fromLong(value.byteValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.byteValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.byteValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value.byteValue()));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromNumber(value));
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse Byte as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromBoolean(Boolean value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(TypedValueUtils.getNumberFromBoolean(value).byteValue());
            }
            case 5: {
                return TypedValue.fromShort(TypedValueUtils.getNumberFromBoolean(value).shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(TypedValueUtils.getNumberFromBoolean(value).intValue());
            }
            case -5: {
                return TypedValue.fromLong(TypedValueUtils.getNumberFromBoolean(value).longValue());
            }
            case 7: {
                return TypedValue.fromFloat(TypedValueUtils.getNumberFromBoolean(value).floatValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(TypedValueUtils.getNumberFromBoolean(value).doubleValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(TypedValueUtils.getNumberFromBoolean(value).intValue()));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(value);
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(TypedValueUtils.getOneZeroStringFromBoolean(value));
            }
        }
        throw new ParseException("Can't parse Boolean as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromBigDecimal(BigDecimal value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(value.byteValue());
            }
            case 5: {
                return TypedValue.fromShort(value.shortValue());
            }
            case 4: {
                return TypedValue.fromInteger(value.intValue());
            }
            case -5: {
                return TypedValue.fromLong(value.longValue());
            }
            case 7: {
                return TypedValue.fromFloat(value.floatValue());
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(value.doubleValue());
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(value);
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(value.intValue() != 0);
            }
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value.toString());
            }
        }
        throw new ParseException("Can't parse BigDecimal as type " + targetSqlType, 0);
    }

    private static TypedValue buildTypedValueFromString(String value, int targetSqlType) throws ParseException {
        switch (targetSqlType) {
            case -6: {
                return TypedValue.fromByte(Byte.parseByte(value));
            }
            case 5: {
                return TypedValue.fromShort(Short.parseShort(value));
            }
            case 4: {
                return TypedValue.fromInteger(Integer.parseInt(value));
            }
            case -5: {
                return TypedValue.fromLong(Long.parseLong(value));
            }
            case 7: {
                return TypedValue.fromFloat(Float.parseFloat(value));
            }
            case 6: 
            case 8: {
                return TypedValue.fromDouble(Double.parseDouble(value));
            }
            case 2: 
            case 3: {
                return TypedValue.fromBigDecimal(new BigDecimal(value));
            }
            case -7: 
            case 16: {
                return TypedValue.fromBoolean(TypedValueUtils.getBooleanFromString(value));
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return TypedValue.fromString(value);
            }
            case -4: 
            case -3: 
            case -2: {
                return TypedValue.fromBytes(value.getBytes(StandardCharsets.UTF_8));
            }
            case 91: {
                return TypedValue.fromDate(TypedValueUtils.getDateFromString(value));
            }
            case 92: {
                return TypedValue.fromTime(TypedValueUtils.getTimeFromString(value));
            }
            case 93: {
                return TypedValue.fromTimestamp(TypedValueUtils.getTimestampFromString(value));
            }
        }
        throw new ParseException("Can't parse String as type " + targetSqlType, 0);
    }

    static {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SQL_DATE_FORMAT = simpleDateFormat;
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SQL_TIME_FORMAT = simpleDateFormat1;
    }
}

