/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.polypheny.jdbc.dependency.org.slf4j.Logger;
import org.polypheny.jdbc.dependency.org.slf4j.LoggerFactory;

public class VersionUtil {
    @Generated
    private static final Logger log;
    private static final String VERSION_FILE = "polypheny-jdbc-driver-version.properties";
    private static final String API_VERSION_PROPERTIES = "prism-api-version.properties";
    public static final int MAJOR;
    public static final int MINOR;
    public static final String QUALIFIER;
    public static final String BUILD_TIMESTAMP;
    public static final String VERSION_STRING;
    public static final int MAJOR_API_VERSION;
    public static final int MINOR_API_VERSION;
    public static final String API_VERSION_STRING;

    static {
        block31: {
            Throwable throwable;
            InputStream inputStream;
            Properties properties;
            block30: {
                log = LoggerFactory.getLogger(VersionUtil.class);
                properties = new Properties();
                try {
                    inputStream = VersionUtil.class.getClassLoader().getResourceAsStream(VERSION_FILE);
                    throwable = null;
                    try {
                        if (inputStream != null) {
                            properties.load(inputStream);
                            MAJOR = Integer.parseInt(properties.getProperty("major"));
                            MINOR = Integer.parseInt(properties.getProperty("minor"));
                            QUALIFIER = properties.getProperty("qualifier");
                            BUILD_TIMESTAMP = properties.getProperty("buildTimestamp");
                            VERSION_STRING = properties.getProperty("version");
                            break block30;
                        }
                        throw new FileNotFoundException("The version properties could not be found.");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading version properties", e);
                }
            }
            properties = new Properties();
            try {
                inputStream = VersionUtil.class.getClassLoader().getResourceAsStream(API_VERSION_PROPERTIES);
                throwable = null;
                try {
                    if (inputStream != null) {
                        properties.load(inputStream);
                        API_VERSION_STRING = properties.getProperty("version");
                        MAJOR_API_VERSION = Integer.parseInt(properties.getProperty("majorVersion"));
                        MINOR_API_VERSION = Integer.parseInt(properties.getProperty("minorVersion"));
                        break block31;
                    }
                    throw new FileNotFoundException("The prism api version properties could not be found.");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading API version properties", e);
            }
        }
    }
}

