/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1)
@Measurement(iterations=50)
@Warmup(iterations=10)
@State(value=Scope.Thread)
@Threads(value=1)
@BenchmarkMode(value={Mode.SingleShotTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class FinalizeConnection {
    private Properties connectionProperties;
    private String connectionUrl;
    private Driver driver;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props;
        this.connectionProperties = props = ConnectionUtil.getProperties();
        this.connectionUrl = ConnectionUtil.getURL();
        this.driver = DriverManager.getDriver(this.connectionUrl);
    }

    @Benchmark
    public void baseline() throws SQLException {
    }

    @Benchmark
    public Connection createAndClose() throws SQLException {
        Connection connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
        connection.close();
        return connection;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(FinalizeConnection.class.getSimpleName()).addProfiler(GCProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

