/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.core.Utils;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class UTF8Encoding {
    @Param(value={"1", "5", "10", "50", "100"})
    public int length;
    private String source;
    private CharsetEncoder encoder;
    private ByteBuffer buf;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Setup
    public void setup() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append("Hello \u043c\u0438\u0440,");
        }
        this.source = sb.toString();
        this.encoder = UTF_8.newEncoder();
        this.buf = ByteBuffer.allocate(10240);
    }

    @Benchmark
    public byte[] utilsEncodeUTF8_old() {
        ByteBuffer buf = UTF_8.encode(CharBuffer.wrap(this.source));
        byte[] b = new byte[buf.limit()];
        buf.get(b, 0, buf.limit());
        return b;
    }

    @Benchmark
    public byte[] utilsEncodeUTF8_current() {
        return Utils.encodeUTF8((String)this.source);
    }

    @Benchmark
    public byte[] string_getBytes() {
        return this.source.getBytes(UTF_8);
    }

    @Benchmark
    public ByteBuffer charset_encode() {
        return UTF_8.encode(this.source);
    }

    @Benchmark
    public Object encoder_byteBufferReuse() throws CharacterCodingException {
        this.buf.clear();
        return this.encoder.encode(CharBuffer.wrap(this.source), this.buf, true);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(UTF8Encoding.class.getSimpleName()).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

