/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.profilers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;

public class FlightRecorderProfiler
implements ExternalProfiler {
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    public Collection<String> addJVMOptions(BenchmarkParams params) {
        StringBuilder sb = new StringBuilder();
        for (String param : params.getParamsKeys()) {
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(param).append('-').append(params.getParam(param));
        }
        long duration = FlightRecorderProfiler.getDurationSeconds(params.getWarmup()) + FlightRecorderProfiler.getDurationSeconds(params.getMeasurement());
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-XX:+UnlockCommercialFeatures");
        opts.add("-XX:+FlightRecorder");
        if (!System.getProperty("java.version").startsWith("1.7")) {
            opts.add("-XX:+UnlockDiagnosticVMOptions");
            opts.add("-XX:+DebugNonSafepoints");
        }
        opts.add("-XX:StartFlightRecording=settings=profile,duration=" + duration + "s,filename=" + params.getBenchmark() + "_" + sb + ".jfr");
        return opts;
    }

    private static long getDurationSeconds(IterationParams warmup) {
        return warmup.getTime().convertTo(TimeUnit.SECONDS) * (long)warmup.getCount();
    }

    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    public boolean allowPrintOut() {
        return true;
    }

    public boolean allowPrintErr() {
        return true;
    }

    public String getDescription() {
        return "Collects Java Flight Recorder profile";
    }
}

