/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.benchmark.profilers.FlightRecorderProfiler;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BindArray {
    private Connection connection;
    private PreparedStatement ps;
    Integer[] ints;
    @Param(value={"1", "5", "10", "50", "100", "1000"})
    int arraySize;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props = ConnectionUtil.getProperties();
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        this.ps = this.connection.prepareStatement("SELECT ?");
        this.ints = new Integer[this.arraySize];
        for (int i = 0; i < this.arraySize; ++i) {
            this.ints[i] = i + 1;
        }
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.ps.close();
        this.connection.close();
    }

    @Benchmark
    public Statement setObject() throws SQLException {
        Array sqlInts = this.connection.createArrayOf("int", this.ints);
        this.ps.setObject(1, (Object)sqlInts, 2003);
        return this.ps;
    }

    @Benchmark
    public Statement setArray() throws SQLException {
        Array sqlInts = this.connection.createArrayOf("int", this.ints);
        this.ps.setArray(1, sqlInts);
        return this.ps;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(BindArray.class.getSimpleName()).addProfiler(GCProfiler.class).addProfiler(FlightRecorderProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

