/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.benchmark.profilers.FlightRecorderProfiler;
import org.postgresql.util.ConnectionUtil;

@Fork(value=0, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BindBoolean {
    private Connection connection;
    private PreparedStatement ps;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props = ConnectionUtil.getProperties();
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        this.ps = this.connection.prepareStatement("select ?");
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.ps.close();
        this.connection.close();
    }

    @Benchmark
    public Statement boolAsInt() throws SQLException {
        this.ps.setObject(1, (Object)1, 16);
        return this.ps;
    }

    @Benchmark
    public Statement boolAsBoolean() throws SQLException {
        this.ps.setObject(1, (Object)true, 16);
        return this.ps;
    }

    @Benchmark
    public Statement bindBoolean() throws SQLException {
        this.ps.setBoolean(1, true);
        return this.ps;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(BindBoolean.class.getSimpleName()).addProfiler(GCProfiler.class).addProfiler(FlightRecorderProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

