/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FinalizeStatement {
    @Param(value={"0", "1", "10", "100"})
    private int leakPct;
    private float leakPctFloat;
    private Connection connection;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props = ConnectionUtil.getProperties();
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        this.leakPctFloat = 0.01f * (float)this.leakPct;
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.connection.close();
    }

    @Benchmark
    public Statement createAndLeak() throws SQLException {
        Statement statement = this.connection.createStatement();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (((Random)rnd).nextFloat() >= this.leakPctFloat) {
            statement.close();
        }
        return statement;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(FinalizeStatement.class.getSimpleName()).addProfiler(GCProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

