/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class InsertBatch {
    private Connection connection;
    private PreparedStatement ps;
    private PreparedStatement structInsert;
    String[] strings;
    @Param(value={"16", "128", "1024"})
    int p1nrows;
    @Param(value={"1", "4", "8", "16", "128"})
    int p2multi;

    @Setup(value=Level.Trial)
    public void setUp(BenchmarkParams bp) throws SQLException {
        int i;
        if (bp.getBenchmark().contains("insertExecute")) {
            if (this.p2multi != 1) {
                System.exit(-1);
            }
        } else if (this.p2multi != 128 && this.p1nrows != 1024) {
            System.exit(-1);
        }
        this.p2multi = Math.min(this.p2multi, this.p1nrows);
        Properties props = ConnectionUtil.getProperties();
        if (bp.getBenchmark().contains("insertBatchWithRewrite")) {
            props.put("reWriteBatchedInserts", "true");
        }
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        Statement s = this.connection.createStatement();
        try {
            s.execute("drop table batch_perf_test");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.execute("create table batch_perf_test(a int4, b varchar(100), c int4)");
        s.close();
        String sql = "insert into batch_perf_test(a, b, c) values(?, ?, ?)";
        for (i = 1; i < this.p2multi; ++i) {
            sql = sql + ",(?,?,?)";
        }
        this.ps = this.connection.prepareStatement(sql);
        this.structInsert = this.connection.prepareStatement("insert into batch_perf_test select * from unnest(?::batch_perf_test[])");
        this.strings = new String[this.p1nrows];
        for (i = 0; i < this.p1nrows; ++i) {
            this.strings[i] = "s" + i;
        }
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.ps.close();
        Statement s = this.connection.createStatement();
        s.execute("drop table batch_perf_test");
        s.close();
        this.connection.close();
    }

    @Benchmark
    public int[] insertBatch() throws SQLException {
        if (this.p2multi > 1) {
            int i = 0;
            while (i < this.p1nrows) {
                int k = 0;
                int pos = 1;
                while (k < this.p2multi) {
                    this.ps.setInt(pos, i);
                    this.ps.setString(++pos, this.strings[i]);
                    this.ps.setInt(++pos, i);
                    ++pos;
                    ++k;
                    ++i;
                }
                this.ps.addBatch();
            }
        } else {
            for (int i = 0; i < this.p1nrows; ++i) {
                this.ps.setInt(1, i);
                this.ps.setString(2, this.strings[i]);
                this.ps.setInt(3, i);
                this.ps.addBatch();
            }
        }
        return this.ps.executeBatch();
    }

    @Benchmark
    public int[] insertBatchWithRewrite() throws SQLException {
        return this.insertBatch();
    }

    @Benchmark
    public void insertExecute(Blackhole b) throws SQLException {
        for (int i = 0; i < this.p1nrows; ++i) {
            this.ps.setInt(1, i);
            this.ps.setString(2, this.strings[i]);
            this.ps.setInt(3, i);
            b.consume(this.ps.execute());
        }
    }

    @Benchmark
    public int[] insertStruct() throws SQLException, IOException {
        CharArrayWriter wr = new CharArrayWriter();
        int i = 0;
        while (i < this.p1nrows) {
            wr.reset();
            wr.append('{');
            int k = 0;
            while (k < this.p2multi) {
                if (k != 0) {
                    wr.append(',');
                }
                wr.append("\"(");
                wr.append(Integer.toString(i));
                wr.append(',');
                String str = this.strings[i];
                if (str != null) {
                    boolean hasQuotes;
                    boolean bl = hasQuotes = str.indexOf(34) != -1;
                    if (hasQuotes) {
                        wr.append("\"");
                        wr.append(str.replace("\"", "\\\""));
                        wr.append("\"");
                    } else {
                        wr.append(str);
                    }
                }
                wr.append(',');
                wr.append(Integer.toString(i));
                wr.append(")\"");
                ++k;
                ++i;
            }
            wr.append('}');
            this.structInsert.setString(1, wr.toString());
            this.structInsert.addBatch();
        }
        return this.structInsert.executeBatch();
    }

    @Benchmark
    public void insertCopy(Blackhole b) throws SQLException, IOException {
        CopyManager copyAPI = ((PGConnection)this.connection).getCopyAPI();
        CharArrayWriter wr = new CharArrayWriter();
        int i = 0;
        while (i < this.p1nrows) {
            CopyIn copyIn = copyAPI.copyIn("COPY batch_perf_test FROM STDIN");
            wr.reset();
            int k = 0;
            while (k < this.p2multi) {
                wr.append(Integer.toString(i));
                wr.append('\t');
                String str = this.strings[i];
                if (str != null) {
                    boolean hasTabs;
                    boolean bl = hasTabs = str.indexOf(9) != -1;
                    if (hasTabs) {
                        wr.append("\"");
                        wr.append(str.replace("\"", "\"\""));
                        wr.append("\"");
                    } else {
                        wr.append(str);
                    }
                }
                wr.append('\t');
                wr.append(Integer.toString(i));
                wr.append('\n');
                ++k;
                ++i;
            }
            byte[] bytes = wr.toString().getBytes("UTF-8");
            copyIn.writeToCopy(bytes, 0, bytes.length);
            b.consume(copyIn.endCopy());
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(InsertBatch.class.getSimpleName()).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

