/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class ParseStatement {
    @Param(value={"0", "1", "10", "20"})
    private int bindCount;
    @Param(value={"false"})
    public boolean unique;
    private Connection connection;
    @Param(value={"conservative"})
    private String autoSave;
    private String sql;
    private int cntr;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props = ConnectionUtil.getProperties();
        props.put("autosave", this.autoSave);
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        Statement st = this.connection.createStatement();
        this.connection.setAutoCommit(false);
        st.execute("BEGIN");
        st.close();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < this.bindCount; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        this.sql = sb.toString();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.connection.close();
    }

    @Benchmark
    public Statement bindExecuteFetch(Blackhole b) throws SQLException {
        String sql = this.sql;
        if (this.unique) {
            sql = sql + " -- " + this.cntr++;
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        for (int i = 1; i <= this.bindCount; ++i) {
            ps.setInt(i, i);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            for (int i = 1; i <= this.bindCount; ++i) {
                b.consume(rs.getInt(i));
            }
        }
        rs.close();
        ps.close();
        return ps;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ParseStatement.class.getSimpleName()).addProfiler(GCProfiler.class).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

