/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=3, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProcessBoolean {
    private Connection connection;
    private PreparedStatement ps;
    private ResultSet rs;
    @Param(value={"5", "10", "50", "100", "10000"})
    public int rowsize;
    @Param(value={"0", "10", "50", "100"})
    private int tokens;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        Properties props = ConnectionUtil.getProperties();
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        this.ps = this.connection.prepareStatement("select (random() > 0.5) from generate_series(1, ?)", 1004, 1007);
        this.ps.setInt(1, this.rowsize);
        this.rs = this.ps.executeQuery();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.rs.close();
        this.ps.close();
        this.connection.close();
    }

    @Benchmark
    public void getBoolean(Blackhole b) throws SQLException {
        Blackhole.consumeCPU((long)this.tokens);
        this.rs.first();
        while (this.rs.next()) {
            b.consume(this.rs.getBoolean(1));
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ProcessBoolean.class.getSimpleName()).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

