/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.postgresql.util.ConnectionUtil;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class ProcessResultSet {
    @Param(value={"1", "50", "100"})
    private int nrows;
    @Param(value={"5"})
    private int ncols;
    @Param
    private FieldType type;
    @Param(value={"false"})
    public boolean unique;
    @Param(value={"BEST"})
    public GetterType getter;
    @Param(value={"NAME"})
    public ColumnIndexType columnIndexType;
    @Param(value={"false"})
    public boolean reuseStatement;
    private Connection connection;
    private PreparedStatement ps;
    private String sql;
    private int cntr;
    private String[] columnNames;

    @Setup(value=Level.Trial)
    public void setUp() throws SQLException {
        if (this.reuseStatement && this.unique) {
            System.out.println("It does not make sense to test reuseStatement && unique combination. Terminating to save time");
            System.exit(-1);
        }
        if (this.type == FieldType.TIMESTAMP) {
            System.out.println("TimeZone.getDefault().getDisplayName() = " + TimeZone.getDefault().getDisplayName());
        }
        Properties props = ConnectionUtil.getProperties();
        this.connection = DriverManager.getConnection(ConnectionUtil.getURL(), props);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        this.columnNames = new String[this.ncols];
        for (int i = 0; i < this.ncols; ++i) {
            String columnName;
            if (i > 0) {
                sb.append(", ");
            }
            if (this.type == FieldType.INT) {
                sb.append("t.x");
            }
            if (this.type == FieldType.BIGINT) {
                sb.append("1234567890123456789");
            }
            if (this.type == FieldType.BIGDECIMAL) {
                sb.append("12345678901234567890123456789");
            } else if (this.type == FieldType.STRING) {
                sb.append("'test string'");
            } else if (this.type == FieldType.TIMESTAMP) {
                sb.append("localtimestamp");
            } else if (this.type == FieldType.TIMESTAMPTZ) {
                sb.append("current_timestamp");
            } else if (this.type == FieldType.BOOL) {
                sb.append("TRUE");
            }
            this.columnNames[i] = columnName = "c" + String.valueOf(System.currentTimeMillis()) + String.valueOf(i);
            sb.append(' ').append(columnName);
        }
        sb.append(" from generate_series(1, ?) as t(x)");
        this.sql = sb.toString();
        if (this.reuseStatement) {
            this.ps = this.connection.prepareStatement(this.sql);
        }
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws SQLException {
        this.connection.close();
    }

    @Benchmark
    public Statement bindExecuteFetch(Blackhole b) throws SQLException {
        String sql = this.sql;
        if (this.unique) {
            sql = sql + " -- " + this.cntr++;
        }
        PreparedStatement ps = this.reuseStatement ? this.ps : this.connection.prepareStatement(sql);
        ps.setInt(1, this.nrows);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            for (int i = 1; i <= this.ncols; ++i) {
                if (this.columnIndexType == ColumnIndexType.INDEX) {
                    this.getByIndex(b, rs, i);
                    continue;
                }
                this.getByName(b, rs, this.columnNames[i - 1]);
            }
        }
        rs.close();
        if (!this.reuseStatement) {
            ps.close();
        }
        return ps;
    }

    private void getByIndex(Blackhole b, ResultSet rs, int i) throws SQLException {
        if (this.getter == GetterType.OBJECT) {
            b.consume(rs.getObject(i));
        } else if (this.type == FieldType.INT) {
            b.consume(rs.getInt(i));
        } else if (this.type == FieldType.BIGINT) {
            b.consume((Object)rs.getBigDecimal(i));
        } else if (this.type == FieldType.BIGDECIMAL) {
            b.consume((Object)rs.getBigDecimal(i));
        } else if (this.type == FieldType.STRING) {
            b.consume((Object)rs.getString(i));
        } else if (this.type == FieldType.TIMESTAMP) {
            b.consume((Object)rs.getTimestamp(i));
        } else if (this.type == FieldType.TIMESTAMPTZ) {
            b.consume((Object)rs.getTimestamp(i));
        } else if (this.type == FieldType.BOOL) {
            b.consume(rs.getBoolean(i));
        }
    }

    private void getByName(Blackhole b, ResultSet rs, String i) throws SQLException {
        if (this.getter == GetterType.OBJECT) {
            b.consume(rs.getObject(i));
        } else if (this.type == FieldType.INT) {
            b.consume(rs.getInt(i));
        } else if (this.type == FieldType.BIGINT) {
            b.consume((Object)rs.getBigDecimal(i));
        } else if (this.type == FieldType.BIGDECIMAL) {
            b.consume((Object)rs.getBigDecimal(i));
        } else if (this.type == FieldType.STRING) {
            b.consume((Object)rs.getString(i));
        } else if (this.type == FieldType.TIMESTAMP) {
            b.consume((Object)rs.getTimestamp(i));
        } else if (this.type == FieldType.TIMESTAMPTZ) {
            b.consume((Object)rs.getTimestamp(i));
        } else if (this.type == FieldType.BOOL) {
            b.consume(rs.getBoolean(i));
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ProcessResultSet.class.getSimpleName()).detectJvmArgs().build();
        new Runner(opt).run();
    }

    public static enum GetterType {
        BEST,
        OBJECT;

    }

    public static enum ColumnIndexType {
        INDEX,
        NAME;

    }

    public static enum FieldType {
        INT,
        BIGINT,
        BIGDECIMAL,
        STRING,
        TIMESTAMP,
        TIMESTAMPTZ,
        BOOL;

    }
}

