/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.benchmark.time;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Fork(value=1, jvmArgsPrepend={"-Xmx128m"})
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class TimestampToTime {
    private static final long ONEDAY = TimeUnit.DAYS.toMillis(1L);
    @Param(value={"GMT+02:00", "Europe/Moscow"})
    String tz;
    TimeZone timeZone;
    Timestamp ts = new Timestamp(System.currentTimeMillis());
    Calendar cachedCalendar = new GregorianCalendar();

    @Setup
    public void init() {
        this.timeZone = TimeZone.getTimeZone(this.tz);
    }

    @Benchmark
    public long simple() {
        long millis = this.ts.getTime() + 10L;
        this.ts.setTime(millis);
        Calendar cal = this.cachedCalendar;
        cal.setTimeZone(this.timeZone);
        cal.setTimeInMillis(millis);
        cal.set(0, 1);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTimeInMillis();
    }

    private static boolean isSimpleTimeZone(String id) {
        return id.startsWith("GMT") || id.startsWith("UTC");
    }

    @Benchmark
    public long advanced() {
        long millis = this.ts.getTime() + 10L;
        TimeZone tz = this.timeZone;
        if (TimestampToTime.isSimpleTimeZone(tz.getID())) {
            int offset = tz.getRawOffset();
            millis += (long)offset;
            millis %= ONEDAY;
            return millis -= (long)offset;
        }
        this.ts.setTime(millis);
        Calendar cal = this.cachedCalendar;
        cal.setTimeZone(tz);
        cal.setTimeInMillis(millis);
        cal.set(0, 1);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTimeInMillis();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(TimestampToTime.class.getSimpleName()).detectJvmArgs().build();
        new Runner(opt).run();
    }
}

