/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Properties;
import org.postgresql.PGProperty;

public class ConnectionUtil {
    public static String getUser() {
        return System.getProperty("user", "test");
    }

    public static String getPassword() {
        return System.getProperty("password", "password");
    }

    public static String getServer() {
        return System.getProperty("server", "localhost");
    }

    public static int getPort() {
        return Integer.parseInt(System.getProperty("port", System.getProperty("def_pgport", "5432")));
    }

    public static String getDatabase() {
        return System.getProperty("database", "test");
    }

    public static String getURL() {
        return "jdbc:postgresql://" + ConnectionUtil.getServer() + ":" + ConnectionUtil.getPort() + "/" + ConnectionUtil.getDatabase();
    }

    public static Properties getProperties() {
        Properties properties = new Properties(System.getProperties());
        PGProperty.USER.set(properties, ConnectionUtil.getUser());
        PGProperty.PASSWORD.set(properties, ConnectionUtil.getPassword());
        PGProperty.PG_PORT.set(properties, ConnectionUtil.getPort());
        properties.setProperty("database", ConnectionUtil.getDatabase());
        properties.setProperty("server", ConnectionUtil.getServer());
        return properties;
    }
}

