/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecLookup;
import io.r2dbc.postgresql.codec.CodecMetadata;
import io.r2dbc.postgresql.codec.DefaultCodecLookup;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import reactor.util.Logger;
import reactor.util.Loggers;

class CachedCodecLookup
implements CodecLookup {
    private static final Logger LOG = Loggers.getLogger(CachedCodecLookup.class);
    private final Map<Integer, Codec<?>> decodeCodecsCache = new ConcurrentHashMap();
    private final Map<Integer, Codec<?>> encodeCodecsCache = new ConcurrentHashMap();
    private final Map<Integer, Codec<?>> encodeNullCodecsCache = new ConcurrentHashMap();
    private final CodecLookup delegate;

    public CachedCodecLookup(Iterable<Codec<?>> codecRegistry) {
        this.delegate = new DefaultCodecLookup(codecRegistry);
    }

    public CachedCodecLookup(CodecLookup delegate) {
        Assert.requireNonType(delegate, CachedCodecLookup.class, "delegate must not be of type CodecFinderCacheImpl");
        this.delegate = delegate;
    }

    @Override
    public Iterator<Codec<?>> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void afterCodecAdded() {
        this.decodeCodecsCache.clear();
        this.encodeCodecsCache.clear();
        this.encodeNullCodecsCache.clear();
        for (Codec c : this.delegate) {
            Optional<Object> arrayClass = Optional.empty();
            if (c instanceof ArrayCodec) {
                ArrayCodec ac2 = (ArrayCodec)c;
                arrayClass = Optional.of(Array.newInstance(ac2.getComponentType(), 0).getClass());
            }
            if (!(c instanceof CodecMetadata)) continue;
            CodecMetadata metadata = (CodecMetadata)((Object)c);
            this.cacheEncode(c, metadata.type());
            arrayClass.ifPresent(ac -> this.cacheEncode(c, (Class<?>)ac));
            for (PostgresTypeIdentifier identifier : metadata.getDataTypes()) {
                for (Format format : metadata.getFormats()) {
                    this.cacheDecode(c, metadata.type(), identifier, format);
                    arrayClass.ifPresent(ac -> this.cacheDecode(c, (Class<?>)ac, identifier, format));
                }
            }
        }
        for (PostgresqlObjectId identifier : PostgresqlObjectId.values()) {
            for (Format format : Format.all()) {
                Codec<Object> c = this.delegate.findDecodeCodec(identifier.getObjectId(), format, Object.class);
                if (c == null) continue;
                this.cacheDecode(c, Object.class, identifier, format);
            }
        }
    }

    @Override
    public <T> Codec<T> findDecodeCodec(int dataType, Format format, Class<? extends T> type) {
        Integer hash = CachedCodecLookup.generateCodecHash(dataType, format, type);
        return this.findCodec(hash, this.decodeCodecsCache, () -> {
            LOG.trace("[codec-finder dataType={}, format={}, type={}] Decode codec not found in cache", new Object[]{dataType, format, type.getName()});
            Codec c = this.delegate.findDecodeCodec(dataType, format, type);
            if (c != null) {
                this.decodeCodecsCache.putIfAbsent(hash, c);
            }
            return c;
        });
    }

    @Override
    public <T> Codec<T> findEncodeCodec(T value) {
        Integer hash = CachedCodecLookup.generateCodecHash(value.getClass());
        return this.findCodec(hash, this.encodeCodecsCache, () -> {
            LOG.trace("[codec-finder type={}] Encode codec not found in cache", new Object[]{value.getClass().getName()});
            Codec<Object> c = this.delegate.findEncodeCodec(value);
            if (c != null) {
                this.encodeCodecsCache.putIfAbsent(hash, c);
            }
            return c;
        });
    }

    @Override
    public <T> Codec<T> findEncodeNullCodec(Class<T> type) {
        Integer hash = CachedCodecLookup.generateCodecHash(type);
        return this.findCodec(hash, this.encodeNullCodecsCache, () -> {
            LOG.trace("[codec-finder type={}] Encode null codec not found in cache", new Object[]{type.getName()});
            Codec c = this.delegate.findEncodeNullCodec(type);
            if (c != null) {
                this.encodeNullCodecsCache.putIfAbsent(hash, c);
            }
            return c;
        });
    }

    private void cacheDecode(Codec<?> c, Class<?> type, PostgresTypeIdentifier identifier, Format format) {
        Integer decodeHash = CachedCodecLookup.generateCodecHash(identifier.getObjectId(), format, type);
        this.decodeCodecsCache.putIfAbsent(decodeHash, c);
    }

    private void cacheEncode(Codec<?> c, Class<?> type) {
        Integer encodeHash = CachedCodecLookup.generateCodecHash(type);
        this.encodeCodecsCache.putIfAbsent(encodeHash, c);
        if (c.canEncodeNull(type)) {
            this.encodeNullCodecsCache.putIfAbsent(encodeHash, c);
        }
    }

    private synchronized <T> Codec<T> findCodec(Integer codecHash, Map<Integer, Codec<?>> cache, Supplier<Codec<T>> fallback) {
        Codec<?> value = cache.get(codecHash);
        return value != null ? value : fallback.get();
    }

    private static Integer generateCodecHash(int dataType, Format format, Class<?> type) {
        int hash = (dataType << 5) - dataType;
        hash = (hash << 5) - hash + format.hashCode();
        hash = (hash << 5) - hash + CachedCodecLookup.generateCodecHash(type);
        return hash;
    }

    private static Integer generateCodecHash(Class<?> type) {
        int hash = type.hashCode();
        if (type.getComponentType() != null) {
            hash = (hash << 5) - hash + CachedCodecLookup.generateCodecHash(type.getComponentType());
        }
        return hash;
    }
}

