/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlRow;
import io.r2dbc.postgresql.PostgresqlRowMetadata;
import io.r2dbc.postgresql.api.ErrorDetails;
import io.r2dbc.postgresql.api.PostgresqlResult;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.DataRow;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.backend.NoticeResponse;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class PostgresqlSegmentResult
extends AbstractReferenceCounted
implements PostgresqlResult {
    private final Flux<Result.Segment> segments;

    private PostgresqlSegmentResult(Flux<Result.Segment> segments) {
        this.segments = segments;
    }

    PostgresqlSegmentResult(ConnectionResources resources, Flux<BackendMessage> messages, ExceptionFactory factory) {
        Assert.requireNonNull(resources, "resources must not be null");
        Assert.requireNonNull(messages, "messages must not be null");
        Assert.requireNonNull(factory, "factory must not be null");
        AtomicReference rowDescriptionHolder = new AtomicReference();
        AtomicReference metadataHolder = new AtomicReference();
        this.segments = messages.doOnNext(message -> {
            if (message instanceof RowDescription) {
                rowDescriptionHolder.set((RowDescription)message);
                metadataHolder.set(PostgresqlRowMetadata.toRowMetadata(resources.getCodecs(), (RowDescription)message));
            }
        }).handle((message, sink) -> {
            if (message instanceof ErrorResponse) {
                sink.next((Object)new PostgresErrorSegment((ErrorResponse)message, factory));
                return;
            }
            if (message instanceof NoticeResponse) {
                sink.next((Object)new PostgresNoticeSegment((NoticeResponse)message, factory));
                return;
            }
            if (message instanceof CommandComplete) {
                Integer rowCount = ((CommandComplete)message).getRows();
                if (rowCount != null) {
                    sink.next((Object)new PostgresqlUpdateCountSegment(rowCount.intValue()));
                }
                return;
            }
            if (message instanceof DataRow) {
                RowDescription rowDescription = (RowDescription)rowDescriptionHolder.get();
                PostgresqlRowMetadata metadata = (PostgresqlRowMetadata)metadataHolder.get();
                if (rowDescription == null) {
                    sink.error((Throwable)new IllegalStateException("DataRow without RowDescription"));
                    return;
                }
                if (metadata == null) {
                    sink.error((Throwable)new IllegalStateException("DataRow without PostgresqlRowMetadata"));
                    return;
                }
                sink.next((Object)new PostgresqlRowSegment(PostgresqlRow.toRow(resources, (DataRow)message, metadata, rowDescription), (ReferenceCounted)((DataRow)message)));
                return;
            }
            ReferenceCountUtil.release((Object)message);
        });
    }

    @Override
    public Mono<Long> getRowsUpdated() {
        return this.segments.handle((segment, sink) -> {
            try {
                if (segment instanceof PostgresErrorSegment) {
                    sink.error((Throwable)((PostgresErrorSegment)segment).exception());
                    return;
                }
                if (segment instanceof Result.UpdateCount) {
                    sink.next((Object)((int)((Result.UpdateCount)segment).value()));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)segment);
            }
        }).collectList().handle((list, sink) -> {
            if (list.isEmpty()) {
                return;
            }
            long sum = 0L;
            for (Integer integer : list) {
                sum += (long)integer.intValue();
            }
            sink.next((Object)sum);
        });
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.segments.handle((segment, sink) -> {
            try {
                if (segment instanceof PostgresErrorSegment) {
                    sink.error((Throwable)((PostgresErrorSegment)segment).exception());
                    return;
                }
                if (segment instanceof Result.RowSegment) {
                    Result.RowSegment row = (Result.RowSegment)segment;
                    sink.next(f.apply(row.row(), row.row().getMetadata()));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)segment);
            }
        });
    }

    public PostgresqlSegmentResult filter(Predicate<Result.Segment> filter) {
        Assert.requireNonNull(filter, "filter must not be null");
        return new PostgresqlSegmentResult((Flux<Result.Segment>)this.segments.filter(it -> {
            boolean result = filter.test((Result.Segment)it);
            if (!result) {
                ReferenceCountUtil.release((Object)it);
            }
            return result;
        }));
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        return this.segments.concatMap(segment -> {
            Publisher result = (Publisher)mappingFunction.apply((Result.Segment)segment);
            if (result == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (result instanceof Mono) {
                return ((Mono)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
            }
            return Flux.from((Publisher)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
        });
    }

    protected void deallocate() {
        this.getRowsUpdated().subscribe();
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public String toString() {
        return "PostgresqlSegmentResult{segments=" + this.segments + '}';
    }

    static PostgresqlSegmentResult toResult(ConnectionResources resources, Flux<BackendMessage> messages, ExceptionFactory factory) {
        return new PostgresqlSegmentResult(resources, messages, factory);
    }

    static class PostgresNoticeSegment
    implements Result.Message {
        private final ExceptionFactory factory;
        private final ErrorDetails details;

        public PostgresNoticeSegment(NoticeResponse response, ExceptionFactory factory) {
            this.factory = factory;
            this.details = new ErrorDetails(response.getFields());
        }

        public R2dbcException exception() {
            return this.factory.createException(this.details);
        }

        public int errorCode() {
            return 0;
        }

        public String sqlState() {
            return this.details.getCode();
        }

        public String message() {
            return this.details.getMessage();
        }
    }

    static class PostgresErrorSegment
    implements Result.Message {
        private final ExceptionFactory factory;
        private final ErrorDetails details;

        public PostgresErrorSegment(ErrorResponse response, ExceptionFactory factory) {
            this.factory = factory;
            this.details = new ErrorDetails(response.getFields());
        }

        public R2dbcException exception() {
            return this.factory.createException(this.details);
        }

        public int errorCode() {
            return 0;
        }

        public String sqlState() {
            return this.details.getCode();
        }

        public String message() {
            return this.details.getMessage();
        }
    }

    static class PostgresqlUpdateCountSegment
    implements Result.UpdateCount {
        private final long value;

        public PostgresqlUpdateCountSegment(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    static class PostgresqlRowSegment
    extends AbstractReferenceCounted
    implements Result.RowSegment {
        private final Row row;
        private final ReferenceCounted releaseable;

        public PostgresqlRowSegment(Row row, ReferenceCounted releaseable) {
            this.row = row;
            this.releaseable = releaseable;
        }

        public Row row() {
            return this.row;
        }

        protected void deallocate() {
            ReferenceCountUtil.release((Object)this.releaseable);
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }
}

