/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.util;

import java.io.File;
import reactor.util.annotation.Nullable;

public final class Assert {
    private Assert() {
    }

    public static <T> Class<T> requireArrayDimension(Class<T> type, int dimension, String message) {
        Assert.requireNonNull(type, "t must not be null");
        Assert.requireNonNull(message, "message must not be null");
        Class<Object> t = type;
        int d = 0;
        while (t.isArray()) {
            t = t.getComponentType();
            ++d;
        }
        if (d != dimension) {
            throw new IllegalArgumentException(String.format(message, d, dimension));
        }
        return type;
    }

    public static <T> T requireNonNull(@Nullable T t, String message) {
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static String requireNotEmpty(@Nullable String t, String message) {
        if (t == null || t.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static <T> T requireType(Object value, Class<T> type, String message) {
        Assert.requireNonNull(value, "value must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(message, "message must not be null");
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException(message);
        }
        return (T)value;
    }

    public static <T> Object requireNonType(Object value, Class<T> type, String message) {
        Assert.requireNonNull(value, "value must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(message, "message must not be null");
        if (type.isInstance(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static String requireFileExistsOrNull(@Nullable String file, String message) {
        if (file == null) {
            throw new IllegalArgumentException(message);
        }
        if (!new File(file).exists()) {
            throw new IllegalArgumentException(message);
        }
        return file;
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

