/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class StartupMessage
implements FrontendMessage {
    private static final ByteBuf DATABASE = Unpooled.copiedBuffer((CharSequence)"database", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf USER = Unpooled.copiedBuffer((CharSequence)"user", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final Map<String, ByteBuf> STATIC_STRINGS = new HashMap<String, ByteBuf>();
    private final String database;
    private final StartupParameterProvider parameterProvider;
    private final String username;

    public StartupMessage(@Nullable String database, String username, StartupParameterProvider parameterProvider) {
        this.database = database;
        this.username = Assert.requireNonNull(username, "username must not be null");
        this.parameterProvider = Assert.requireNonNull(parameterProvider, "parameterProvider must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeShort(out, 3, 0);
            StartupMessage.writeParameter(out, USER, this.username);
            if (this.database != null) {
                StartupMessage.writeParameter(out, DATABASE, this.database);
            }
            ByteBufParameterWriter writer = new ByteBufParameterWriter(out);
            this.parameterProvider.accept(writer);
            FrontendMessageUtils.writeByte(out, 0);
            return FrontendMessageUtils.writeSize(out, 0);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartupMessage that = (StartupMessage)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.username);
    }

    public String toString() {
        return "StartupMessage{database='" + this.database + '\'' + ", username='" + this.username + '\'' + '}';
    }

    static void writeParameter(ByteBuf out, ByteBuf key, String value) {
        FrontendMessageUtils.writeCString(out, key);
        FrontendMessageUtils.writeCStringUTF8(out, value);
    }

    static {
        List<String> strings = Arrays.asList("2", "application_name", "client_encoding", "DateStyle", "extra_float_digits", "ISO", "TimeZone", "utf8");
        for (String string : strings) {
            STATIC_STRINGS.put(string, Unpooled.copiedBuffer((CharSequence)string, (Charset)CharsetUtil.UTF_8).asReadOnly());
        }
    }

    public static interface StartupParameterProvider {
        public void accept(ParameterWriter var1);
    }

    static class ByteBufParameterWriter
    implements ParameterWriter {
        private final ByteBuf out;

        ByteBufParameterWriter(ByteBuf out) {
            this.out = out;
        }

        @Override
        public void write(String key, String value) {
            ByteBuf binaryKey = (ByteBuf)STATIC_STRINGS.get(key);
            ByteBuf binaryValue = (ByteBuf)STATIC_STRINGS.get(value);
            if (binaryKey == null) {
                FrontendMessageUtils.writeCStringASCII(this.out, key);
            } else {
                FrontendMessageUtils.writeCString(this.out, binaryKey);
            }
            if (binaryValue == null) {
                FrontendMessageUtils.writeCStringUTF8(this.out, value);
            } else {
                FrontendMessageUtils.writeCString(this.out, binaryValue);
            }
        }
    }

    public static interface ParameterWriter {
        public void write(String var1, String var2);
    }
}

