/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.graph.DirectedEdge;
import poussecafe.doc.graph.DirectedGraph;
import poussecafe.doc.graph.Node;
import poussecafe.doc.graph.NodeStyle;
import poussecafe.doc.graph.NodesAndEdges;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;

public class AggregateEventsGraphFactory {
    public static DirectedGraph buildGraph(Aggregate aggregate, Domain domain) {
        DocumentationItem aggregateDoc = aggregate.documentation();
        String moduleName = aggregateDoc.moduleName();
        Logger.info("Building events graph for aggregate {}", aggregateDoc.name());
        DirectedGraph graph = new DirectedGraph();
        NodesAndEdges nodesAndEdges = graph.getNodesAndEdges();
        String aggregateName = aggregateDoc.name();
        Node aggregateNode = Node.box(aggregateName);
        aggregateNode.setStyle(Optional.of(NodeStyle.BOLD));
        nodesAndEdges.addNode(aggregateNode);
        List aggregateSteps = domain.listeners(moduleName).filter(item -> item.aggregate().isPresent()).filter(item -> item.aggregate().orElseThrow().equals(aggregateName)).collect(Collectors.toList());
        for (MessageListener stepDoc : aggregateSteps) {
            Object producedEvent2;
            Node fromExternalNode;
            StepMethodSignature signature = stepDoc.stepMethodSignature().orElseThrow();
            Optional<String> optionalConsumedEvent = signature.consumedEventName();
            if (!optionalConsumedEvent.isPresent()) continue;
            String consumedEvent = optionalConsumedEvent.get();
            Node eventNode = Node.ellipse(consumedEvent);
            nodesAndEdges.addNode(eventNode);
            nodesAndEdges.addEdge(DirectedEdge.solidEdge(consumedEvent, aggregateName));
            List<MessageListener> fromSteps = domain.findProducing(moduleName, consumedEvent);
            for (MessageListener messageListener : fromSteps) {
                Optional<String> optionalAggregateDocId = messageListener.aggregate();
                if (!optionalAggregateDocId.isPresent()) continue;
                fromExternalNode = Node.box(optionalAggregateDocId.orElseThrow());
                nodesAndEdges.addNode(fromExternalNode);
                nodesAndEdges.addEdge(DirectedEdge.solidEdge(optionalAggregateDocId.orElseThrow(), consumedEvent));
            }
            List<String> fromExternals = stepDoc.fromExternals();
            for (String fromExternal : fromExternals) {
                fromExternalNode = Node.box(fromExternal);
                fromExternalNode.setStyle(Optional.of(NodeStyle.DASHED));
                nodesAndEdges.addNode(fromExternalNode);
                nodesAndEdges.addEdge(DirectedEdge.solidEdge(fromExternal, consumedEvent));
            }
            for (Object producedEvent2 : stepDoc.producedEvents()) {
                Node producedEventNode = Node.ellipse(((NameRequired)producedEvent2).name());
                nodesAndEdges.addNode(producedEventNode);
                if (((NameRequired)producedEvent2).required()) {
                    nodesAndEdges.addEdge(DirectedEdge.solidEdge(aggregateName, ((NameRequired)producedEvent2).name()));
                } else {
                    nodesAndEdges.addEdge(DirectedEdge.dashedEdge(aggregateName, ((NameRequired)producedEvent2).name()));
                }
                List<MessageListener> toSteps = domain.findConsuming(moduleName, ((NameRequired)producedEvent2).name());
                for (MessageListener toStep : toSteps) {
                    Optional<String> optionalAggregateDocId = toStep.aggregate();
                    if (!optionalAggregateDocId.isPresent()) continue;
                    Node fromExternalNode2 = Node.box(optionalAggregateDocId.orElseThrow());
                    nodesAndEdges.addNode(fromExternalNode2);
                    nodesAndEdges.addEdge(DirectedEdge.solidEdge(((NameRequired)producedEvent2).name(), optionalAggregateDocId.orElseThrow()));
                }
            }
            List<String> list = stepDoc.toExternals();
            producedEvent2 = list.iterator();
            while (producedEvent2.hasNext()) {
                String toExternal = (String)producedEvent2.next();
                Node toExternalNode = Node.box(toExternal);
                toExternalNode.setStyle(Optional.of(NodeStyle.DASHED));
                nodesAndEdges.addNode(toExternalNode);
                nodesAndEdges.addEdge(DirectedEdge.solidEdge(aggregateName, toExternal));
            }
            Map<NameRequired, List<String>> toExternalsByEvent = stepDoc.toExternalsByEvent();
            for (Map.Entry<NameRequired, List<String>> toExternal : toExternalsByEvent.entrySet()) {
                NameRequired eventName = toExternal.getKey();
                List<String> externalNames = toExternal.getValue();
                Node toEventNode = Node.ellipse(eventName.name());
                nodesAndEdges.addNode(toEventNode);
                if (eventName.required()) {
                    nodesAndEdges.addEdge(DirectedEdge.solidEdge(aggregateName, eventName.name()));
                } else {
                    nodesAndEdges.addEdge(DirectedEdge.dashedEdge(aggregateName, eventName.name()));
                }
                for (String externalName : externalNames) {
                    Node toExternalNode = Node.box(externalName);
                    toExternalNode.setStyle(Optional.of(NodeStyle.DASHED));
                    nodesAndEdges.addNode(toExternalNode);
                    nodesAndEdges.addEdge(DirectedEdge.solidEdge(eventName.name(), externalName));
                }
            }
        }
        return graph;
    }

    private AggregateEventsGraphFactory() {
    }
}

