/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.Objects;
import java.util.Optional;
import poussecafe.doc.DomainProcessStepsFactory;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.graph.DirectedEdge;
import poussecafe.doc.graph.DirectedGraph;
import poussecafe.doc.graph.Node;
import poussecafe.doc.graph.NodeStyle;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.DomainProcessGraphNodes;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNode;
import poussecafe.doc.model.domainprocessdoc.ToStep;

public class DomainProcessGraphFactory {
    private DocumentationItem domainProcessDoc;
    private Domain domain;

    public DirectedGraph buildGraph() {
        Logger.info("Building graph for process {}", this.domainProcessDoc.name());
        DirectedGraph graph = new DirectedGraph();
        DomainProcessGraphNodes nodes = DomainProcessStepsFactory.buildDomainProcessGraphNodes(this.domainProcessDoc, this.domain);
        for (DomainProcessGraphNode domainProcessGraphNode : nodes.orderedSteps()) {
            if (domainProcessGraphNode.external()) {
                Node node = Node.box(domainProcessGraphNode.componentDoc().name());
                node.setStyle(Optional.of(NodeStyle.DASHED));
                graph.getNodesAndEdges().addNode(node);
            } else {
                graph.getNodesAndEdges().addNode(Node.ellipse(domainProcessGraphNode.componentDoc().name()));
            }
            for (ToStep to : domainProcessGraphNode.tos()) {
                DomainProcessGraphNode stepTo = nodes.getStep(to.name());
                DirectedEdge edge = to.directly() ? DirectedEdge.solidEdge(domainProcessGraphNode.componentDoc().name(), to.name().stringValue()) : DirectedEdge.dashedEdge(domainProcessGraphNode.componentDoc().name(), to.name().stringValue());
                Optional<String> consumedEvent = stepTo.consumedEvent();
                if (consumedEvent.isPresent()) {
                    edge.setLabel(consumedEvent.get());
                }
                graph.getNodesAndEdges().addEdge(edge);
            }
        }
        return graph;
    }

    private DomainProcessGraphFactory() {
    }

    public static class Builder {
        private DomainProcessGraphFactory factory = new DomainProcessGraphFactory();

        public Builder domainProcessDoc(DocumentationItem domainProcessDoc) {
            this.factory.domainProcessDoc = domainProcessDoc;
            return this;
        }

        public Builder domain(Domain domain) {
            this.factory.domain = domain;
            return this;
        }

        public DomainProcessGraphFactory build() {
            Objects.requireNonNull(this.factory.domainProcessDoc);
            Objects.requireNonNull(this.factory.domain);
            return this.factory;
        }
    }
}

