/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.discovery.DefaultProcess;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.DomainProcessGraphNodes;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.MessageListenersPerEvent;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNode;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNodeName;
import poussecafe.doc.model.domainprocessdoc.ToStep;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.Documentation;

public class DomainProcessStepsFactory {
    public static DomainProcessGraphNodes buildDomainProcessGraphNodes(DocumentationItem domainProcessDoc, Domain domain) {
        DomainProcessGraphNodes.Builder stepsBuilder = new DomainProcessGraphNodes.Builder();
        DocumentationItem moduleComponentDoc = domainProcessDoc;
        String moduleDocId = moduleComponentDoc.moduleName();
        String processName = moduleComponentDoc.name();
        List<MessageListener> listeners = domain.listeners(moduleDocId, processName);
        MessageListenersPerEvent eventToConsumingStepsMap = DomainProcessStepsFactory.buildConsumingStepsPerEvent(listeners);
        HashSet<DomainProcessGraphNodeName> otherProcesses = new HashSet<DomainProcessGraphNodeName>();
        for (MessageListener listener : listeners) {
            ArrayList<ToStep> currentStepToSteps = new ArrayList<ToStep>();
            List<DomainProcessGraphNodeName> toInternals = eventToConsumingStepsMap.locateToInternals(listener);
            currentStepToSteps.addAll(DomainProcessStepsFactory.toDirectSteps(toInternals));
            Set<ToStep> toExternals = DomainProcessStepsFactory.locateToExternals(listener);
            stepsBuilder.merge(DomainProcessStepsFactory.toExternalStepsMap(toExternals));
            currentStepToSteps.addAll(toExternals);
            List<ToStep> toDomainProcesses = DomainProcessStepsFactory.locateToDomainProcesses(domainProcessDoc, listener, domain);
            otherProcesses.addAll(toDomainProcesses.stream().map(ToStep::name).collect(Collectors.toList()));
            stepsBuilder.merge(DomainProcessStepsFactory.toExternalStepsMap(toDomainProcesses));
            currentStepToSteps.addAll(toDomainProcesses);
            DocumentationItem processStepComponentDoc = listener.documentation();
            DomainProcessGraphNode currentStep = new DomainProcessGraphNode.Builder().componentDoc(processStepComponentDoc).tos(currentStepToSteps).build();
            stepsBuilder.add(currentStep);
            DomainProcessGraphNodeName currentStepName = new DomainProcessGraphNodeName(processStepComponentDoc.name());
            ToStep toCurrentStep = DomainProcessStepsFactory.directStep(currentStepName);
            List<DomainProcessGraphNodeName> fromExternals = DomainProcessStepsFactory.locateFromExternals(listener);
            stepsBuilder.merge(DomainProcessStepsFactory.fromExternalStepsMap(fromExternals, toCurrentStep));
            List<DomainProcessGraphNodeName> fromDomainProcesses = DomainProcessStepsFactory.fromDomainProcesses(domainProcessDoc, listener, domain);
            otherProcesses.addAll(fromDomainProcesses);
            stepsBuilder.merge(DomainProcessStepsFactory.fromExternalStepsMap(fromDomainProcesses, toCurrentStep));
        }
        Map<DomainProcessGraphNodeName, DomainProcessGraphNode> interprocessSteps = DomainProcessStepsFactory.buildInterprocessSteps(moduleDocId, otherProcesses, domain);
        stepsBuilder.merge(interprocessSteps);
        return stepsBuilder.build();
    }

    private static List<DomainProcessGraphNodeName> locateFromExternals(MessageListener processStepDoc) {
        return processStepDoc.fromExternals().stream().map(DomainProcessGraphNodeName::new).collect(Collectors.toList());
    }

    private static Map<DomainProcessGraphNodeName, DomainProcessGraphNode> fromExternalStepsMap(List<DomainProcessGraphNodeName> fromExternals, ToStep toCurrentStep) {
        HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode> fromExternalSteps = new HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode>();
        for (DomainProcessGraphNodeName fromExternal : fromExternals) {
            DomainProcessGraphNode fromExternalStep = new DomainProcessGraphNode.Builder().componentDoc(new DocumentationItem.Builder().id("from" + fromExternal).name(fromExternal.stringValue()).description(Documentation.empty()).build()).external(true).to(toCurrentStep).build();
            fromExternalSteps.put(fromExternalStep.stepName(), fromExternalStep);
        }
        return fromExternalSteps;
    }

    private static Map<DomainProcessGraphNodeName, DomainProcessGraphNode> toExternalStepsMap(Collection<ToStep> externalStepsNames) {
        HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode> steps = new HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode>();
        for (ToStep externalToStep : externalStepsNames) {
            DomainProcessGraphNodeName externalStepName = externalToStep.name();
            steps.computeIfAbsent(externalStepName, key -> new DomainProcessGraphNode.Builder().componentDoc(new DocumentationItem.Builder().id("to" + externalStepName).name(externalStepName.stringValue()).description(Documentation.empty()).build()).external(true).build());
        }
        return steps;
    }

    private static MessageListenersPerEvent buildConsumingStepsPerEvent(List<MessageListener> processStepDocs) {
        MessageListenersPerEvent.Builder builder = new MessageListenersPerEvent.Builder();
        for (MessageListener processStepDoc : processStepDocs) {
            builder.withMessageListener(processStepDoc);
        }
        return builder.build();
    }

    private static List<ToStep> toDirectSteps(Collection<DomainProcessGraphNodeName> tos) {
        ArrayList<ToStep> toSteps = new ArrayList<ToStep>();
        for (DomainProcessGraphNodeName to : tos) {
            toSteps.add(DomainProcessStepsFactory.directStep(to));
        }
        return toSteps;
    }

    private static ToStep directStep(DomainProcessGraphNodeName to) {
        return new ToStep.Builder().name(to).directly(true).build();
    }

    private static Set<ToStep> locateToExternals(MessageListener processStepDoc) {
        HashSet<ToStep> toExternals = new HashSet<ToStep>();
        toExternals.addAll(processStepDoc.toExternals().stream().map(DomainProcessGraphNodeName::new).map(DomainProcessStepsFactory::directStep).collect(Collectors.toList()));
        for (Map.Entry<NameRequired, List<String>> entry : processStepDoc.toExternalsByEvent().entrySet()) {
            boolean required = entry.getKey().required();
            toExternals.addAll(entry.getValue().stream().map(name -> DomainProcessStepsFactory.toStep(name, required)).collect(Collectors.toList()));
        }
        return toExternals;
    }

    private static ToStep toStep(String name, boolean required) {
        return new ToStep.Builder().name(new DomainProcessGraphNodeName(name)).directly(required).build();
    }

    private static List<ToStep> locateToDomainProcesses(DocumentationItem processDoc, MessageListener listener, Domain domain) {
        Set<NameRequired> producedEvents = listener.producedEvents();
        String domainProcessName = processDoc.name();
        String moduleDocId = processDoc.moduleName();
        HashSet<ToStep> toDomainProcesses = new HashSet<ToStep>();
        for (NameRequired producedEvent : producedEvents) {
            for (MessageListener nextListener : domain.findConsuming(moduleDocId, producedEvent.name())) {
                Set<String> processNames = nextListener.processNames();
                for (String processName : processNames) {
                    if (processName.equals(domainProcessName)) continue;
                    toDomainProcesses.add(new ToStep.Builder().name(new DomainProcessGraphNodeName(processName)).directly(producedEvent.required()).build());
                }
            }
        }
        return toDomainProcesses.stream().collect(Collectors.toList());
    }

    private static List<DomainProcessGraphNodeName> fromDomainProcesses(DocumentationItem domainProcessDoc, MessageListener processStepDoc, Domain domain) {
        Optional<StepMethodSignature> stepMethodSignature = processStepDoc.stepMethodSignature();
        Optional<Object> consumedEvent = Optional.empty();
        if (stepMethodSignature.isPresent()) {
            consumedEvent = stepMethodSignature.get().consumedEventName();
        }
        String domainProcessName = domainProcessDoc.name();
        HashSet<String> otherDomainProcesses = new HashSet<String>();
        if (consumedEvent.isPresent()) {
            String moduleDocId = domainProcessDoc.moduleName();
            List<MessageListener> stepsProducingEvent = domain.findProducing(moduleDocId, (String)consumedEvent.get());
            for (MessageListener stepDoc : stepsProducingEvent) {
                Set<String> processNames = stepDoc.processNames();
                for (String processName : processNames) {
                    if (processName.equals(domainProcessName)) continue;
                    otherDomainProcesses.add(processName);
                }
            }
        }
        return otherDomainProcesses.stream().map(DomainProcessGraphNodeName::new).collect(Collectors.toList());
    }

    private static Map<DomainProcessGraphNodeName, DomainProcessGraphNode> buildInterprocessSteps(String moduleName, Set<DomainProcessGraphNodeName> otherProcesses, Domain domain) {
        HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode> interprocessSteps = new HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode>();
        ArrayList<DomainProcessGraphNodeName> otherProcessesList = new ArrayList<DomainProcessGraphNodeName>(otherProcesses);
        HashMap<DomainProcessGraphNodeName, Set> producedEventsPerProcess = new HashMap<DomainProcessGraphNodeName, Set>();
        HashMap<DomainProcessGraphNodeName, Set> consumedEventsPerProcess = new HashMap<DomainProcessGraphNodeName, Set>();
        for (int i = 0; i < otherProcessesList.size(); ++i) {
            DomainProcessGraphNodeName processName1 = (DomainProcessGraphNodeName)((Object)otherProcessesList.get(i));
            Optional<ClassName> process1ClassName = DomainProcessStepsFactory.processClassName(moduleName, domain, processName1);
            Set producedEventsOf1 = producedEventsPerProcess.computeIfAbsent(processName1, name -> DomainProcessStepsFactory.producedEventsOfProcess(moduleName, name, domain));
            Set consumedEventsOf1 = consumedEventsPerProcess.computeIfAbsent(processName1, name -> DomainProcessStepsFactory.consumedEventsOfProcess(moduleName, name, domain));
            for (int j = i + 1; j < otherProcessesList.size(); ++j) {
                Set<String> producedBy2AndConsumedBy1;
                DomainProcessGraphNodeName processName2 = (DomainProcessGraphNodeName)((Object)otherProcessesList.get(j));
                Optional<ClassName> process2ClassName = DomainProcessStepsFactory.processClassName(moduleName, domain, processName2);
                Set producedEventsOf2 = producedEventsPerProcess.computeIfAbsent(processName2, name -> DomainProcessStepsFactory.producedEventsOfProcess(moduleName, name, domain));
                Set consumedEventsOf2 = consumedEventsPerProcess.computeIfAbsent(processName2, name -> DomainProcessStepsFactory.consumedEventsOfProcess(moduleName, name, domain));
                Set<String> producedBy1AndConsumedBy2 = DomainProcessStepsFactory.intersect(producedEventsOf1, consumedEventsOf2);
                if (!producedBy1AndConsumedBy2.isEmpty()) {
                    interprocessSteps.put(processName1, new DomainProcessGraphNode.Builder().componentDoc(new DocumentationItem.Builder().id(processName1 + "_" + processName2).className(process1ClassName).name(processName1.stringValue()).description(Documentation.empty()).moduleName(moduleName).build()).to(DomainProcessStepsFactory.directStep(processName2)).build());
                }
                if ((producedBy2AndConsumedBy1 = DomainProcessStepsFactory.intersect(producedEventsOf2, consumedEventsOf1)).isEmpty()) continue;
                interprocessSteps.put(processName2, new DomainProcessGraphNode.Builder().componentDoc(new DocumentationItem.Builder().id(processName2 + "_" + processName1).className(process2ClassName).name(processName2.stringValue()).description(Documentation.empty()).moduleName(moduleName).build()).to(DomainProcessStepsFactory.directStep(processName1)).build());
            }
        }
        return interprocessSteps;
    }

    private static Optional<ClassName> processClassName(String moduleName, Domain domain, DomainProcessGraphNodeName processName) {
        if (processName.stringValue().equals(DefaultProcess.class.getSimpleName())) {
            return Optional.empty();
        }
        return domain.module(moduleName).orElseThrow().processes().stream().filter(process -> process.name().equals(processName.stringValue())).findFirst().map(DocumentationItem::className).orElse(Optional.empty());
    }

    private static Set<String> producedEventsOfProcess(String moduleDocId, DomainProcessGraphNodeName processName, Domain domain) {
        HashSet<String> producedEvents = new HashSet<String>();
        List<MessageListener> processStepDocs = domain.listeners(moduleDocId, processName.stringValue());
        for (MessageListener stepDoc : processStepDocs) {
            producedEvents.addAll(stepDoc.producedEvents().stream().map(NameRequired::name).collect(Collectors.toList()));
        }
        return producedEvents;
    }

    private static Set<String> consumedEventsOfProcess(String moduleDocId, DomainProcessGraphNodeName processName, Domain domain) {
        HashSet<String> consumedEvents = new HashSet<String>();
        List<MessageListener> processStepDocs = domain.listeners(moduleDocId, processName.stringValue());
        for (MessageListener stepDoc : processStepDocs) {
            Optional<String> consumedEvent;
            Optional<StepMethodSignature> signature = stepDoc.stepMethodSignature();
            if (!signature.isPresent() || !(consumedEvent = signature.get().consumedEventName()).isPresent()) continue;
            consumedEvents.add(consumedEvent.get());
        }
        return consumedEvents;
    }

    private static Set<String> intersect(Set<String> set1, Set<String> set2) {
        HashSet<String> intersection = new HashSet<String>(set1);
        intersection.retainAll(set2);
        return intersection;
    }

    private DomainProcessStepsFactory() {
    }
}

