/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import poussecafe.doc.graph.DirectedEdge;
import poussecafe.doc.graph.DirectedGraphNodesAndEdges;
import poussecafe.doc.graph.DirectedSubGraph;
import poussecafe.doc.graph.Graph;
import poussecafe.doc.graph.Node;
import poussecafe.doc.graph.NodesAndEdges;
import poussecafe.doc.graph.SubGraph;
import poussecafe.doc.graph.UndirectedEdge;
import poussecafe.doc.graph.UndirectedGraph;
import poussecafe.doc.graph.UndirectedGraphNodesAndEdges;
import poussecafe.doc.graph.UndirectedSubGraph;

public class DotPrinter {
    private PrintStream stream;
    private int subGraphCount;

    public DotPrinter(PrintStream stream) {
        this.stream = stream;
    }

    public void print(Graph graph) {
        this.printGraphHeader(graph);
        this.printNodesAndEdges(graph.getNodesAndEdges());
        this.printSubGraphs(graph.getSubGraphs());
        this.printGraphFooter();
    }

    private void printGraphHeader(Graph graph) {
        if (graph instanceof UndirectedGraph) {
            this.printUndirectedGraphHeader();
        } else {
            this.printDirectedGraphHeader();
        }
    }

    private void printNodesAndEdges(NodesAndEdges nodesAndEdges) {
        if (nodesAndEdges instanceof UndirectedGraphNodesAndEdges) {
            this.printUndirectedNodesAndEdges((UndirectedGraphNodesAndEdges)nodesAndEdges);
        } else {
            this.printDirectedNodesAndEdges((DirectedGraphNodesAndEdges)nodesAndEdges);
        }
    }

    private void printSubGraphs(List<SubGraph> subGraphs) {
        for (SubGraph subGraph : subGraphs) {
            this.printSubGraph(subGraph);
        }
    }

    private void printSubGraph(SubGraph subGraph) {
        if (subGraph instanceof UndirectedSubGraph) {
            this.printUndirectedSubGraph((UndirectedSubGraph)subGraph);
        } else {
            this.printDirectedSubGraph((DirectedSubGraph)subGraph);
        }
    }

    private void printUndirectedGraphHeader() {
        this.stream.println("graph {");
        this.stream.println("splines=spline;");
        this.stream.println("overlap=false;");
    }

    private void printGraphFooter() {
        this.stream.println("}");
    }

    private void printUndirectedSubGraph(UndirectedSubGraph subGraph) {
        this.stream.println("subgraph cluster_" + this.subGraphCount++ + " {");
        if (subGraph.hasName()) {
            this.stream.println("label=\"" + subGraph.getName() + "\";");
        }
        this.printUndirectedNodesAndEdges(subGraph.getNodesAndEdges());
        this.printSubGraphs(subGraph.getSubGraphs());
        this.stream.println("}");
    }

    private void printUndirectedNodesAndEdges(UndirectedGraphNodesAndEdges nodesAndEdges) {
        for (UndirectedEdge edge : nodesAndEdges.edges()) {
            this.printUndirectedEdge(edge);
        }
        for (Node node : nodesAndEdges.nodes()) {
            this.printNode(node);
        }
    }

    private void printNode(Node node) {
        this.stream.print("\"");
        this.stream.print(node.getName());
        this.stream.print("\"");
        ArrayList<CallSite> attributes = new ArrayList<CallSite>();
        if (node.getShape().isPresent()) {
            attributes.add((CallSite)((Object)("shape=" + node.getShape().orElseThrow().name().toLowerCase())));
        }
        if (node.getStyle().isPresent()) {
            attributes.add((CallSite)((Object)("style=" + node.getStyle().orElseThrow().name().toLowerCase())));
        }
        if (!attributes.isEmpty()) {
            this.stream.print("[");
            this.stream.print(StringUtils.join(attributes, (char)','));
            this.stream.print("]");
        }
        this.stream.println(";");
    }

    private void printUndirectedEdge(UndirectedEdge edge) {
        this.stream.print("\"");
        this.stream.print(edge.getNode1());
        this.stream.print("\" -- ");
        this.stream.print("\"");
        this.stream.print(edge.getNode2());
        this.stream.print("\"");
        this.stream.print(" [style=" + edge.getStyle().name().toLowerCase() + "]");
        this.stream.println(";");
    }

    private void printDirectedGraphHeader() {
        this.stream.println("digraph {");
        this.stream.println("splines=spline;");
    }

    private void printDirectedSubGraph(DirectedSubGraph subGraph) {
        this.stream.println("subgraph cluster_" + this.subGraphCount++ + " {");
        if (subGraph.hasName()) {
            this.stream.println("label=\"" + subGraph.getName() + "\";");
        }
        this.printDirectedNodesAndEdges(subGraph.getNodesAndEdges());
        this.printSubGraphs(subGraph.getSubGraphs());
        this.stream.println("}");
    }

    private void printDirectedNodesAndEdges(DirectedGraphNodesAndEdges nodesAndEdges) {
        for (DirectedEdge edge : nodesAndEdges.edges()) {
            this.printDirectedEdge(edge);
        }
        for (Node node : nodesAndEdges.nodes()) {
            this.printNode(node);
        }
    }

    private void printDirectedEdge(DirectedEdge edge) {
        this.stream.print("\"");
        this.stream.print(edge.getNode1());
        this.stream.print("\" -> ");
        this.stream.print("\"");
        this.stream.print(edge.getNode2());
        this.stream.print("\"");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("style", edge.getStyle().name().toLowerCase());
        if (edge.getLabel().isPresent()) {
            attributes.put("label", this.quote(edge.getLabel().get()));
        }
        this.stream.print(" [" + this.nodeOrEdgeAttributes(attributes) + "]");
        this.stream.println(";");
    }

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private String nodeOrEdgeAttributes(Map<String, String> attributes) {
        return attributes.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
    }
}

