/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import poussecafe.doc.DotPrinter;
import poussecafe.doc.graph.DirectedGraph;
import poussecafe.doc.graph.Graph;

public class GraphImageWriter {
    private Optional<String> customDotExecutable = Optional.empty();
    private static final String DEFAULT_DOT_EXECUTABLE = "dot";
    private Optional<String> customFdpExecutable = Optional.empty();
    private static final String DEFAULT_FDP_EXECUTABLE = "fdp";

    public void writeImage(Graph graph, File outputDirectory, String graphName) throws IOException {
        File dotFile = new File(outputDirectory, graphName + ".dot");
        PrintStream printStream = new PrintStream(dotFile);
        DotPrinter dotPrinter = new DotPrinter(printStream);
        dotPrinter.print(graph);
        printStream.close();
        String executable = this.chooseExecutable(graph);
        Process process = new ProcessBuilder(executable, "-Tpng", dotFile.getAbsolutePath()).start();
        File pngFile = new File(outputDirectory, graphName + ".png");
        try (FileOutputStream pngOutputStream = new FileOutputStream(pngFile);){
            IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)pngOutputStream);
        }
    }

    private String chooseExecutable(Graph graph) {
        if (graph instanceof DirectedGraph) {
            return this.customDotExecutable.orElse(DEFAULT_DOT_EXECUTABLE);
        }
        return this.customFdpExecutable.orElse(DEFAULT_FDP_EXECUTABLE);
    }

    private GraphImageWriter() {
    }

    public static class Builder {
        private GraphImageWriter writer = new GraphImageWriter();

        public Builder customDotExecutable(Optional<String> customDotExecutable) {
            this.writer.customDotExecutable = customDotExecutable;
            return this;
        }

        public Builder customFdpExecutable(Optional<String> customFdpExecutable) {
            this.writer.customFdpExecutable = customFdpExecutable;
            return this;
        }

        public GraphImageWriter build() {
            Objects.requireNonNull(this.writer.customDotExecutable);
            Objects.requireNonNull(this.writer.customFdpExecutable);
            return this.writer;
        }
    }
}

