/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.doc.AggregateEventsGraphFactory;
import poussecafe.doc.GraphFactory;
import poussecafe.doc.GraphImageWriter;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.Module;

public class GraphImagesWriter {
    private static final String IMAGES_SUB_DIRECTORY = "img";
    private Logger logger;
    private String outputDirectoryPath;
    private GraphImageWriter graphImageWriter;

    public void writeImages(Domain domain) {
        try {
            File outputDirectory = this.outputDirectory();
            for (Module moduleDoc : domain.modules()) {
                this.logger.debug("Drawing BC " + moduleDoc.documentation().name() + " graph...");
                this.graphImageWriter.writeImage(GraphFactory.buildModuleGraph(moduleDoc, domain), outputDirectory, moduleDoc.documentation().id());
                this.writeAggregatesGraphs(moduleDoc, domain);
                this.writeDomainProcessesGraphs(moduleDoc, domain);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing graphs", e);
        }
    }

    private File outputDirectory() {
        File outputDirectory = new File(this.outputDirectoryPath, IMAGES_SUB_DIRECTORY);
        outputDirectory.mkdirs();
        return outputDirectory;
    }

    private void writeAggregatesGraphs(Module module, Domain domain) throws IOException {
        File outputDirectory = this.outputDirectory();
        for (Aggregate aggregate : module.aggregates()) {
            DocumentationItem aggregateDoc = aggregate.documentation();
            this.logger.debug("Drawing aggregate " + aggregateDoc.name() + " graph...");
            String aggregateGraphBaseName = module.documentation().id() + "_" + aggregateDoc.id();
            this.graphImageWriter.writeImage(GraphFactory.buildAggregateGraph(aggregate, domain), outputDirectory, aggregateGraphBaseName);
            String aggregateGraphEventsBaseName = module.documentation().id() + "_" + aggregateDoc.id() + "_events";
            this.graphImageWriter.writeImage(AggregateEventsGraphFactory.buildGraph(aggregate, domain), outputDirectory, aggregateGraphEventsBaseName);
        }
    }

    private void writeDomainProcessesGraphs(Module module, Domain domain) throws IOException {
        File outputDirectory = this.outputDirectory();
        for (DocumentationItem domainProcessDoc : module.processes()) {
            this.logger.debug("Drawing domain process " + domainProcessDoc.name() + " graph...");
            this.graphImageWriter.writeImage(GraphFactory.buildDomainProcessGraph(domainProcessDoc, domain), outputDirectory, module.documentation().id() + "_" + domainProcessDoc.id());
        }
    }

    public static CustomBuilder builder() {
        return new CustomBuilder();
    }

    private static Logger $default$logger() {
        return LoggerFactory.getLogger(GraphImagesWriter.class);
    }

    GraphImagesWriter(Logger logger, String outputDirectoryPath, GraphImageWriter graphImageWriter) {
        this.logger = logger;
        this.outputDirectoryPath = outputDirectoryPath;
        this.graphImageWriter = graphImageWriter;
    }

    public static class BaseBuilder {
        private boolean logger$set;
        private Logger logger$value;
        private String outputDirectoryPath;
        private GraphImageWriter graphImageWriter;

        BaseBuilder() {
        }

        public BaseBuilder logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return this;
        }

        public BaseBuilder outputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
            return this;
        }

        public BaseBuilder graphImageWriter(GraphImageWriter graphImageWriter) {
            this.graphImageWriter = graphImageWriter;
            return this;
        }

        public GraphImagesWriter build() {
            Logger logger$value = this.logger$value;
            if (!this.logger$set) {
                logger$value = GraphImagesWriter.$default$logger();
            }
            return new GraphImagesWriter(logger$value, this.outputDirectoryPath, this.graphImageWriter);
        }

        public String toString() {
            return "GraphImagesWriter.BaseBuilder(logger$value=" + this.logger$value + ", outputDirectoryPath=" + this.outputDirectoryPath + ", graphImageWriter=" + this.graphImageWriter + ")";
        }
    }

    public static class CustomBuilder
    extends BaseBuilder {
        private Optional<String> customDotExecutable = Optional.empty();
        private Optional<String> customFdpExecutable = Optional.empty();

        @Override
        public GraphImagesWriter build() {
            GraphImagesWriter writer = super.build();
            writer.graphImageWriter = new GraphImageWriter.Builder().customDotExecutable(this.customDotExecutable).customFdpExecutable(this.customFdpExecutable).build();
            return writer;
        }

        public CustomBuilder customDotExecutable(Optional<String> customDotExecutable) {
            this.customDotExecutable = customDotExecutable;
            return this;
        }

        public CustomBuilder customFdpExecutable(Optional<String> customFdpExecutable) {
            this.customFdpExecutable = customFdpExecutable;
            return this;
        }
    }
}

