/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import poussecafe.discovery.DefaultProcess;
import poussecafe.doc.StringNormalizer;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.domainprocessdoc.ComponentMethodName;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.ComponentType;
import poussecafe.source.model.ComponentWithType;
import poussecafe.source.model.ProducedEvent;
import poussecafe.source.model.SourceModel;
import poussecafe.source.model.TypeComponent;
import poussecafe.source.model.TypeReference;

public class ModuleBuilder {
    @NonNull
    private TypeComponent module;
    @NonNull
    private SourceModel model;

    public Module build() {
        ClassName moduleClassName = this.module.typeName().asName();
        String id = StringNormalizer.normalizeString(moduleClassName.simple());
        DocumentationItem documentationItem = new DocumentationItem.Builder().className(Optional.of(moduleClassName)).description(this.module.documentation()).id(id).name(this.moduleName()).moduleName(this.moduleName()).build();
        return new Module.Builder().documentation(documentationItem).aggregates(this.aggregates()).services(this.services()).listeners(this.listeners()).processes(this.processes()).build();
    }

    private List<Aggregate> aggregates() {
        return this.model.moduleAggregates(this.module).map(this::buildAggregate).collect(Collectors.toList());
    }

    private Aggregate buildAggregate(poussecafe.source.model.Aggregate sourceAggregate) {
        String moduleName = this.moduleName();
        Aggregate.Builder builder = new Aggregate.Builder();
        String id = StringNormalizer.normalizeString(sourceAggregate.name());
        DocumentationItem documentationItem = new DocumentationItem.Builder().id(id).className(Optional.of(sourceAggregate.className().asName())).description(sourceAggregate.documentation()).moduleName(moduleName).name(sourceAggregate.name()).build();
        return builder.documentation(documentationItem).entities(this.entities(sourceAggregate)).valueObjects(this.valueObjects(sourceAggregate)).build();
    }

    private String moduleName() {
        return this.module.typeName().simpleName();
    }

    private List<DocumentationItem> entities(poussecafe.source.model.Aggregate sourceAggregate) {
        return sourceAggregate.rootReferences().stream().filter(reference -> reference.type() == ComponentType.ENTITY).map(this::entityDocumentation).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<DocumentationItem> entityDocumentation(TypeReference entityDocumentation) {
        return this.model.entities().stream().filter(type -> type.typeName().asName().equals((Object)entityDocumentation.typeClassName())).findAny().map(this::typeComponentDocumentation);
    }

    private DocumentationItem typeComponentDocumentation(TypeComponent component) {
        String componentName = component.typeName().simpleName();
        return new DocumentationItem.Builder().id(StringNormalizer.normalizeString(componentName)).className(Optional.of(component.typeName().asName())).description(component.documentation()).moduleName(this.resolveModuleName(component)).name(componentName).build();
    }

    private String resolveModuleName(TypeComponent component) {
        return this.model.moduleResolver().findModule(component.typeName().asName()).map(ClassName::simple).orElse(DefaultProcess.class.getSimpleName());
    }

    private List<DocumentationItem> valueObjects(poussecafe.source.model.Aggregate sourceAggregate) {
        return sourceAggregate.rootReferences().stream().filter(reference -> reference.type() == ComponentType.VALUE_OBJECT).map(this::valueObjectDocumentation).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<DocumentationItem> valueObjectDocumentation(TypeReference typeReference) {
        return this.model.valueObjects().stream().filter(type -> type.typeName().asName().equals((Object)typeReference.typeClassName())).findAny().map(this::typeComponentDocumentation);
    }

    private List<DocumentationItem> services() {
        return this.model.moduleServices(this.module).map(this::typeComponentDocumentation).collect(Collectors.toList());
    }

    private List<MessageListener> listeners() {
        return this.model.moduleMessageListeners(this.module).map(this::listener).collect(Collectors.toList());
    }

    private MessageListener listener(poussecafe.source.model.MessageListener sourceListener) {
        String id = sourceListener.id();
        return new MessageListener.Builder().aggregate(Optional.of(sourceListener.aggregateName())).documentation(new DocumentationItem.Builder().id(StringNormalizer.normalizeString(id)).className(Optional.empty()).description(sourceListener.documentation()).moduleName(this.moduleName()).name(id).build()).fromExternals(sourceListener.consumesFromExternal()).processNames(new HashSet<String>(sourceListener.processNames())).producedEvents(sourceListener.producedEvents().stream().map(this::producedEvent).collect(Collectors.toSet())).stepMethodSignature(Optional.of(new StepMethodSignature.Builder().componentMethodName(new ComponentMethodName.Builder().componentName(sourceListener.aggregateName()).methodName(sourceListener.methodName()).build()).consumedMessageName(Optional.of(sourceListener.consumedMessage().name())).build())).toExternalsByEvent(sourceListener.producedEvents().stream().collect(Collectors.toMap(this::producedEvent, ProducedEvent::consumedByExternal))).build();
    }

    private NameRequired producedEvent(ProducedEvent event) {
        if (event.required()) {
            return NameRequired.required(event.message().name());
        }
        return NameRequired.optional(event.message().name());
    }

    private List<DocumentationItem> processes() {
        return this.model.moduleProcesses(this.module).map(ComponentWithType::typeComponent).map(this::typeComponentDocumentation).collect(Collectors.toList());
    }

    ModuleBuilder(@NonNull TypeComponent module, @NonNull SourceModel model) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.module = module;
        this.model = model;
    }

    public static ModuleBuilderBuilder builder() {
        return new ModuleBuilderBuilder();
    }

    public static class ModuleBuilderBuilder {
        private TypeComponent module;
        private SourceModel model;

        ModuleBuilderBuilder() {
        }

        public ModuleBuilderBuilder module(@NonNull TypeComponent module) {
            if (module == null) {
                throw new NullPointerException("module is marked non-null but is null");
            }
            this.module = module;
            return this;
        }

        public ModuleBuilderBuilder model(@NonNull SourceModel model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public ModuleBuilder build() {
            return new ModuleBuilder(this.module, this.model);
        }

        public String toString() {
            return "ModuleBuilder.ModuleBuilderBuilder(module=" + this.module + ", model=" + this.model + ")";
        }
    }
}

