/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.doc.graph.Node;
import poussecafe.doc.graph.NodeStyle;
import poussecafe.doc.graph.UndirectedEdge;
import poussecafe.doc.graph.UndirectedGraph;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.Relation;
import poussecafe.doc.model.relationdoc.ComponentType;
import poussecafe.source.analysis.ClassName;

public class ModuleGraphFactory {
    private Module moduleDoc;
    private UndirectedGraph graph = new UndirectedGraph();
    private Domain domain;

    public UndirectedGraph buildGraph() {
        this.addSimpleAggregates();
        return this.graph;
    }

    private void addSimpleAggregates() {
        for (Aggregate aggregateDoc : this.moduleDoc.aggregates()) {
            this.addSimpleAggregate(aggregateDoc);
            this.addAggregateRelations(aggregateDoc);
        }
    }

    private void addSimpleAggregate(Aggregate aggregateDoc) {
        Node node = Node.box(aggregateDoc.documentation().name());
        node.setStyle(Optional.of(NodeStyle.BOLD));
        this.graph.getNodesAndEdges().addNode(node);
    }

    private void addAggregateRelations(Aggregate aggregateDoc) {
        this.addAggregateRelations(aggregateDoc, aggregateDoc.documentation().className().orElseThrow(), new ExplorationState());
    }

    private void addAggregateRelations(Aggregate aggregateDoc, ClassName fromClassName, ExplorationState explorationState) {
        explorationState.exploredComponents.add(fromClassName);
        for (Relation relation : this.findRelationsWithFromClassName(fromClassName)) {
            if (relation.to().type() == ComponentType.AGGREGATE) {
                Aggregate otherAggregate = this.aggregateWithClass(relation.to().className());
                if (aggregateDoc.documentation().id().equals(otherAggregate.documentation().id())) continue;
                UndirectedEdge edge = UndirectedEdge.solidEdge(aggregateDoc.documentation().name(), relation.to().name());
                this.graph.getNodesAndEdges().addEdge(edge);
                continue;
            }
            if (explorationState.exploredComponents.contains(relation.to().className())) continue;
            this.addAggregateRelations(aggregateDoc, relation.to().className(), explorationState);
        }
    }

    private List<Relation> findRelationsWithFromClassName(ClassName fromId) {
        return this.domain.relations().stream().filter(item -> item.from().className().equals((Object)fromId)).collect(Collectors.toList());
    }

    private Aggregate aggregateWithClass(ClassName className) {
        return this.moduleDoc.aggregates().stream().filter(item -> item.documentation().className().equals(Optional.of(className))).findFirst().orElseThrow();
    }

    private ModuleGraphFactory() {
    }

    public static class Builder {
        private ModuleGraphFactory factory = new ModuleGraphFactory();

        public Builder moduleDoc(Module moduleDoc) {
            this.factory.moduleDoc = moduleDoc;
            return this;
        }

        public Builder domain(Domain domain) {
            this.factory.domain = domain;
            return this;
        }

        public ModuleGraphFactory build() {
            Objects.requireNonNull(this.factory.moduleDoc);
            Objects.requireNonNull(this.factory.domain);
            return this.factory;
        }
    }

    private class ExplorationState {
        Set<ClassName> exploredComponents = new HashSet<ClassName>();

        private ExplorationState() {
        }
    }
}

