/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import poussecafe.doc.GraphImagesWriter;
import poussecafe.doc.HtmlWriter;
import poussecafe.doc.ModuleBuilder;
import poussecafe.doc.PdfWriter;
import poussecafe.doc.PousseCafeDocGenerationConfiguration;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.Relation;
import poussecafe.doc.model.relationdoc.Component;
import poussecafe.doc.model.relationdoc.ComponentType;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.Aggregate;
import poussecafe.source.model.SourceModel;
import poussecafe.source.model.TypeComponent;
import poussecafe.source.model.TypeReference;

public class PousseCafeDocGenerator {
    private PousseCafeDocGenerationConfiguration configuration;
    private SourceModel model;

    public void generate() {
        Domain domain = this.buildDomain();
        this.writeGraphs(domain);
        this.writeHtml(domain);
        this.writePdf();
    }

    private Domain buildDomain() {
        return new Domain.Builder().name(this.configuration.domainName()).version(this.configuration.version()).modules(this.modules()).relations(this.relations()).build();
    }

    private List<Module> modules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (TypeComponent module : this.model.modules()) {
            ModuleBuilder builder = ModuleBuilder.builder().model(this.model).module(module).build();
            modules.add(builder.build());
        }
        return modules;
    }

    private List<Relation> relations() {
        HashSet relations = new HashSet();
        this.model.aggregates().forEach(aggregate -> this.addRelations(relations, (Aggregate)aggregate));
        this.model.entities().forEach(entity -> this.addRelations(relations, this.component(ComponentType.ENTITY, (TypeComponent)entity), entity.references()));
        this.model.valueObjects().forEach(valueObject -> this.addRelations(relations, this.component(ComponentType.VALUE_OBJECT, (TypeComponent)valueObject), valueObject.references()));
        return new ArrayList<Relation>(relations);
    }

    private void addRelations(Set<Relation> relations, Aggregate aggregate) {
        Optional<TypeComponent> aggregateIdVo;
        this.addRelations(relations, this.component(aggregate), aggregate.rootReferences());
        Optional aggregateId = aggregate.rootIdentifierClassName();
        if (aggregateId.isPresent() && (aggregateIdVo = this.model.valueObjects().stream().filter(valueObject -> valueObject.typeName().qualifiedName().equals(((ClassName)aggregateId.orElseThrow()).qualified())).findFirst()).isPresent()) {
            Relation aggregateToId = new Relation.Builder().from(this.component(aggregate)).to(new Component(ComponentType.VALUE_OBJECT, aggregateIdVo.orElseThrow().typeName().asName(), aggregateIdVo.orElseThrow().typeName().simpleName())).build();
            relations.add(aggregateToId);
            Relation idToAggregate = new Relation.Builder().from(new Component(ComponentType.VALUE_OBJECT, aggregateIdVo.orElseThrow().typeName().asName(), aggregateIdVo.orElseThrow().typeName().simpleName())).to(this.component(aggregate)).build();
            relations.add(idToAggregate);
        }
    }

    private Component component(Aggregate aggregate) {
        return new Component(ComponentType.AGGREGATE, aggregate.className().asName(), aggregate.name());
    }

    private void addRelations(Set<Relation> relations, Component from, List<TypeReference> references) {
        for (TypeReference reference : references) {
            Relation relation = new Relation.Builder().from(from).to(new Component(this.componentType(reference.type()), reference.typeClassName(), reference.typeClassName().simple())).build();
            relations.add(relation);
        }
    }

    private Component component(ComponentType type, TypeComponent typeComponent) {
        return new Component(type, typeComponent.typeName().asName(), typeComponent.typeName().simpleName());
    }

    private ComponentType componentType(poussecafe.source.model.ComponentType type) {
        return ComponentType.valueOf(type.name());
    }

    private void writeGraphs(Domain domain) {
        GraphImagesWriter graphsWriter = GraphImagesWriter.builder().customDotExecutable(this.configuration.customDotExecutable()).customFdpExecutable(this.configuration.customFdpExecutable()).outputDirectoryPath(this.configuration.outputDirectory()).build();
        graphsWriter.writeImages(domain);
    }

    private void writeHtml(Domain domain) {
        HtmlWriter htmlWriter = new HtmlWriter.Builder().outputDirectoryPath(this.configuration.outputDirectory()).includeGenerationDate(this.configuration.includeGenerationDate()).build();
        htmlWriter.writeHtml(domain);
    }

    private void writePdf() {
        PdfWriter pdfWriter = new PdfWriter(this.configuration);
        pdfWriter.writePdf();
    }

    PousseCafeDocGenerator(PousseCafeDocGenerationConfiguration configuration, SourceModel model) {
        this.configuration = configuration;
        this.model = model;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PousseCafeDocGenerationConfiguration configuration;
        private SourceModel model;

        Builder() {
        }

        public Builder configuration(PousseCafeDocGenerationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder model(SourceModel model) {
            this.model = model;
            return this;
        }

        public PousseCafeDocGenerator build() {
            return new PousseCafeDocGenerator(this.configuration, this.model);
        }

        public String toString() {
            return "PousseCafeDocGenerator.Builder(configuration=" + this.configuration + ", model=" + this.model + ")";
        }
    }
}

