/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.domain.Service;

public class ClassDocPredicates
implements Service {
    private DocletEnvironment docletEnvironment;

    public boolean documentsWithSuperclass(TypeElement typeElement, Class<?> expectedSuperclass) {
        if (expectedSuperclass.isInterface()) {
            throw new IllegalArgumentException("Given expected class is an interface");
        }
        return this.documents(this.asElement(typeElement.getSuperclass()), expectedSuperclass);
    }

    private Element asElement(TypeMirror typeMirror) {
        return this.docletEnvironment.getTypeUtils().asElement(typeMirror);
    }

    public boolean documents(TypeMirror typeElement, Class<?> documentedClass) {
        return this.documents(this.asElement(typeElement), documentedClass);
    }

    public boolean documents(Element element, Class<?> documentedClass) {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return typeElement.getQualifiedName().toString().equals(documentedClass.getName());
        }
        return false;
    }

    public boolean documentsWithSuperinterface(TypeElement typeElement, Class<?> expectedInterface) {
        if (!expectedInterface.isInterface()) {
            throw new IllegalArgumentException("Given expected class is not an interface");
        }
        return this.documents(typeElement.getInterfaces(), expectedInterface);
    }

    public boolean documents(Collection<? extends TypeMirror> typeMirrors, Class<?> expectedType) {
        for (TypeMirror typeMirror : typeMirrors) {
            if (!this.documents(typeMirror, expectedType)) continue;
            return true;
        }
        return false;
    }

    public boolean documentsSubclassOf(TypeElement typeElement, Class<?> expectedSuperclass) {
        if (expectedSuperclass.isInterface()) {
            return this.documentsImplementationOf(typeElement, expectedSuperclass);
        }
        return this.documentsExtensionOf(typeElement, expectedSuperclass);
    }

    private boolean documentsImplementationOf(TypeElement typeElement, Class<?> expectedSuperclass) {
        if (this.documentsWithSuperinterface(typeElement, expectedSuperclass)) {
            return true;
        }
        TypeMirror superClass = typeElement.getSuperclass();
        if (!(superClass instanceof NoType) && this.documentsImplementationOf(this.asElement(superClass), expectedSuperclass)) {
            return true;
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!this.documentsImplementationOf(this.asElement(typeMirror), expectedSuperclass)) continue;
            return true;
        }
        return false;
    }

    private boolean documentsImplementationOf(Element element, Class<?> expectedSuperclass) {
        if (element instanceof TypeElement) {
            return this.documentsImplementationOf((TypeElement)element, expectedSuperclass);
        }
        return false;
    }

    private boolean documentsExtensionOf(TypeElement typeElement, Class<?> expectedSuperclass) {
        throw new UnsupportedOperationException();
    }

    public boolean isEnum(TypeElement classDoc) {
        return classDoc.getKind() == ElementKind.ENUM;
    }
}

