/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import poussecafe.doc.doclet.PathFinder;
import poussecafe.doc.doclet.RelationBuilder;
import poussecafe.doc.model.DocletServices;

public class CodeExplorer {
    private TypeElement rootClassDoc;
    private DocletServices docletServices;
    private String basePackage;
    private RelationBuilder classRelationBuilder;
    private Set<String> alreadyMatched = new HashSet<String>();

    private CodeExplorer() {
    }

    public void explore() {
        this.pathFinder().start();
    }

    private PathFinder pathFinder() {
        return new PathFinder.Builder().start(this.rootClassDoc).basePackage(this.basePackage).classMatcher(this::classMatcher).pathHandler(this::pathHandler).docletServices(this.docletServices).build();
    }

    public void explore(TypeElement start) {
        this.pathFinder().explore(start);
    }

    private boolean classMatcher(TypeElement candidateClassDoc) {
        return this.docletServices.entityDocFactory().isEntityDoc(candidateClassDoc) || this.docletServices.valueObjectDocFactory().isValueObjectDoc(candidateClassDoc);
    }

    private void pathHandler(TypeElement componentFrom, TypeElement componentTo) {
        String relation = componentFrom.getQualifiedName().toString() + "_" + componentTo.getQualifiedName().toString();
        if (!this.alreadyMatched.contains(relation)) {
            this.alreadyMatched.add(relation);
            this.classRelationBuilder.classRelationBuilder(componentFrom, componentTo);
        }
    }

    public static class Builder {
        private CodeExplorer codeExplorer = new CodeExplorer();

        public Builder rootClassDoc(TypeElement classDoc) {
            this.codeExplorer.rootClassDoc = classDoc;
            return this;
        }

        public Builder basePackage(String basePackage) {
            this.codeExplorer.basePackage = basePackage;
            return this;
        }

        public Builder classRelationBuilder(RelationBuilder classRelationBuilder) {
            this.codeExplorer.classRelationBuilder = classRelationBuilder;
            return this;
        }

        public Builder docletServices(DocletServices docletServices) {
            this.codeExplorer.docletServices = docletServices;
            return this;
        }

        public CodeExplorer build() {
            Objects.requireNonNull(this.codeExplorer.rootClassDoc);
            Objects.requireNonNull(this.codeExplorer.basePackage);
            Objects.requireNonNull(this.codeExplorer.classRelationBuilder);
            Objects.requireNonNull(this.codeExplorer.docletServices);
            return this.codeExplorer;
        }
    }
}

