/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.ElementFilter;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.model.AnnotationsResolver;
import poussecafe.source.Ignore;

public class PackagesAnalyzer {
    private DocletEnvironment docletEnvironment;
    private List<Consumer<PackageElement>> packageDocConsumers = new ArrayList<Consumer<PackageElement>>();
    private AnnotationsResolver annotationsResolver;

    private PackagesAnalyzer() {
    }

    public void analyzeCode() {
        Set<PackageElement> classes = ElementFilter.packagesIn(this.docletEnvironment.getIncludedElements());
        for (PackageElement classDoc : classes) {
            if (this.annotationsResolver.isIgnored(classDoc) || !AnnotationUtils.annotation(classDoc, Ignore.class).isEmpty()) continue;
            this.processPackageDoc(classDoc);
        }
    }

    private void processPackageDoc(PackageElement classDoc) {
        for (Consumer<PackageElement> consumer : this.packageDocConsumers) {
            consumer.accept(classDoc);
        }
    }

    public static class Builder {
        private PackagesAnalyzer analyzer = new PackagesAnalyzer();

        public Builder packageDocConsumer(Consumer<PackageElement> packageElementConsumer) {
            Objects.requireNonNull(packageElementConsumer);
            this.analyzer.packageDocConsumers.add(packageElementConsumer);
            return this;
        }

        public PackagesAnalyzer build() {
            return this.analyzer;
        }
    }
}

