/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.graph;

import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import poussecafe.doc.graph.Edge;
import poussecafe.doc.graph.EdgeStyle;

public class DirectedEdge
implements Edge {
    private String node1;
    private String node2;
    private EdgeStyle style;
    private String label;

    public static DirectedEdge solidEdge(String entity1, String entity2) {
        DirectedEdge edge = new DirectedEdge(entity1, entity2);
        edge.setStyle(EdgeStyle.SOLID);
        return edge;
    }

    public static DirectedEdge dashedEdge(String entity1, String entity2) {
        DirectedEdge edge = new DirectedEdge(entity1, entity2);
        edge.setStyle(EdgeStyle.DOTTED);
        return edge;
    }

    public EdgeStyle getStyle() {
        return this.style;
    }

    public void setStyle(EdgeStyle style) {
        this.style = style;
    }

    private DirectedEdge(String node1, String node2) {
        this.setNode1(node1);
        this.setNode2(node2);
    }

    public String getNode1() {
        return this.node1;
    }

    private void setNode1(String node1) {
        this.node1 = node1;
    }

    public String getNode2() {
        return this.node2;
    }

    private void setNode2(String node2) {
        this.node2 = node2;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.node1).append((Object)this.node2).append((Object)this.style).append((Object)this.label).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedEdge other = (DirectedEdge)obj;
        return new EqualsBuilder().append((Object)this.node1, (Object)other.node1).append((Object)this.node2, (Object)other.node2).append((Object)this.style, (Object)other.style).append((Object)this.label, (Object)other.label).build();
    }
}

