/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.graph;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import poussecafe.doc.graph.NodeStyle;
import poussecafe.doc.graph.Shape;
import poussecafe.util.Equality;

public class Node
implements Comparable<Node> {
    private String name;
    private Optional<Shape> shape = Optional.empty();
    private Optional<NodeStyle> style = Optional.empty();

    public static Node box(String name) {
        Node node = new Node(name);
        node.setShape(Optional.of(Shape.BOX));
        return node;
    }

    public static Node ellipse(String name) {
        Node node = new Node(name);
        node.setShape(Optional.of(Shape.ELLIPSE));
        return node;
    }

    public Node(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public Optional<Shape> getShape() {
        return this.shape;
    }

    public void setShape(Optional<Shape> shape) {
        Objects.requireNonNull(shape);
        this.shape = shape;
    }

    public Optional<NodeStyle> getStyle() {
        return this.style;
    }

    public void setStyle(Optional<NodeStyle> style) {
        Objects.requireNonNull(style);
        this.style = style;
    }

    @Override
    public int compareTo(Node o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return Equality.referenceEquals((Object)this, (Object)obj).orElse(other -> new EqualsBuilder().append((Object)this.name, (Object)other.name).build());
    }
}

