/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.graph;

import poussecafe.doc.graph.Edge;
import poussecafe.doc.graph.EdgeStyle;

public class UndirectedEdge
implements Edge {
    private String node1;
    private String node2;
    private EdgeStyle style;

    public static UndirectedEdge solidEdge(String entity1, String entity2) {
        UndirectedEdge edge = new UndirectedEdge(entity1, entity2);
        edge.setStyle(EdgeStyle.SOLID);
        return edge;
    }

    public static UndirectedEdge dashedEdge(String entity1, String entity2) {
        UndirectedEdge edge = new UndirectedEdge(entity1, entity2);
        edge.setStyle(EdgeStyle.DOTTED);
        return edge;
    }

    public EdgeStyle getStyle() {
        return this.style;
    }

    public void setStyle(EdgeStyle style) {
        this.style = style;
    }

    public UndirectedEdge(String node1, String node2) {
        if (node1.compareTo(node2) < 0) {
            this.setNode1(node1);
            this.setNode2(node2);
        } else {
            this.setNode1(node2);
            this.setNode2(node1);
        }
    }

    public String getNode1() {
        return this.node1;
    }

    private void setNode1(String node1) {
        this.node1 = node1;
    }

    public String getNode2() {
        return this.node2;
    }

    private void setNode2(String node2) {
        this.node2 = node2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node1 == null ? 0 : this.node1.hashCode());
        result = 31 * result + (this.node2 == null ? 0 : this.node2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UndirectedEdge other = (UndirectedEdge)obj;
        if (this.node1 == null ? other.node1 != null : !this.node1.equals(other.node1)) {
            return false;
        }
        return !(this.node2 == null ? other.node2 != null : !this.node2.equals(other.node2));
    }
}

