/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import poussecafe.doc.model.DocumentationItem;

public class Aggregate {
    private DocumentationItem documentation;
    private List<DocumentationItem> entities;
    private List<DocumentationItem> valueObjects;

    private Aggregate() {
    }

    public DocumentationItem documentation() {
        return this.documentation;
    }

    public List<DocumentationItem> entities() {
        return this.entities;
    }

    public List<DocumentationItem> valueObjects() {
        return this.valueObjects;
    }

    public static class Builder {
        private Aggregate aggregate = new Aggregate();

        public Builder documentation(DocumentationItem documentation) {
            this.aggregate.documentation = documentation;
            return this;
        }

        public Builder entities(List<DocumentationItem> entities) {
            this.aggregate.entities = new ArrayList<DocumentationItem>(entities);
            return this;
        }

        public Builder valueObjects(List<DocumentationItem> valueObjects) {
            this.aggregate.valueObjects = new ArrayList<DocumentationItem>(valueObjects);
            return this;
        }

        public Aggregate build() {
            Objects.requireNonNull(this.aggregate.documentation);
            Objects.requireNonNull(this.aggregate.entities);
            Objects.requireNonNull(this.aggregate.valueObjects);
            return this.aggregate;
        }
    }
}

