/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.Relation;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.domain.ValueObject;

public class Domain
implements ValueObject {
    private String name;
    private String version;
    private List<Module> modules;
    private List<Relation> relations = new ArrayList<Relation>();

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public List<Module> modules() {
        return this.modules;
    }

    public Optional<Module> module(String moduleName) {
        return this.modules.stream().filter(module -> module.documentation().name().equals(moduleName)).findFirst();
    }

    public List<MessageListener> listeners(String moduleName, String processName) {
        return this.module(moduleName).map(module -> module.listeners(processName)).orElse(Collections.emptyList());
    }

    public List<MessageListener> findConsuming(String moduleName, String messageName) {
        return this.listeners(moduleName).filter(item -> item.stepMethodSignature().isPresent()).filter(item -> item.stepMethodSignature().orElseThrow().consumedEventName().isPresent()).filter(item -> item.stepMethodSignature().orElseThrow().consumedEventName().orElseThrow().equals(messageName)).collect(Collectors.toList());
    }

    public Stream<MessageListener> listeners(String moduleName) {
        return this.module(moduleName).map(module -> module.listeners().stream()).orElse(Stream.empty());
    }

    public List<MessageListener> findProducing(String moduleName, String messageName) {
        return this.listeners(moduleName).filter(item -> item.producedEvents().stream().map(NameRequired::name).collect(Collectors.toSet()).contains(messageName)).collect(Collectors.toList());
    }

    public List<Relation> relations() {
        return Collections.unmodifiableList(this.relations);
    }

    private Domain() {
    }

    public static class Builder {
        private Domain domain = new Domain();

        public Builder name(String name) {
            this.domain.name = name;
            return this;
        }

        public Builder version(String version) {
            this.domain.version = version;
            return this;
        }

        public Builder modules(List<Module> modules) {
            this.domain.modules = new ArrayList<Module>(modules);
            return this;
        }

        public Builder relations(List<Relation> relations) {
            this.domain.relations.addAll(relations);
            return this;
        }

        public Domain build() {
            Objects.requireNonNull(this.domain.name);
            Objects.requireNonNull(this.domain.version);
            Objects.requireNonNull(this.domain.modules);
            return this.domain;
        }
    }
}

