/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;

public class MessageListener {
    private StepMethodSignature stepMethodSignature;
    private DocumentationItem documentation;
    private Set<NameRequired> producedEvents = new HashSet<NameRequired>();
    @Deprecated
    private List<String> toExternals = new ArrayList<String>();
    private Map<NameRequired, List<String>> toExternalsByEvent = new HashMap<NameRequired, List<String>>();
    private Set<String> processNames = new HashSet<String>();
    private List<String> fromExternals = new ArrayList<String>();
    private String aggregate;

    public Optional<StepMethodSignature> stepMethodSignature() {
        return Optional.ofNullable(this.stepMethodSignature);
    }

    public DocumentationItem documentation() {
        return this.documentation;
    }

    public Set<NameRequired> producedEvents() {
        return Collections.unmodifiableSet(this.producedEvents);
    }

    @Deprecated
    public List<String> toExternals() {
        return Collections.unmodifiableList(this.toExternals);
    }

    public Map<NameRequired, List<String>> toExternalsByEvent() {
        return Collections.unmodifiableMap(this.toExternalsByEvent);
    }

    public Set<String> processNames() {
        return Collections.unmodifiableSet(this.processNames);
    }

    public List<String> fromExternals() {
        return Collections.unmodifiableList(this.fromExternals);
    }

    public Optional<String> aggregate() {
        return Optional.ofNullable(this.aggregate);
    }

    private MessageListener() {
    }

    public static class Builder {
        private MessageListener listener = new MessageListener();

        public MessageListener build() {
            Objects.requireNonNull(this.listener.documentation);
            return this.listener;
        }

        public Builder stepMethodSignature(Optional<StepMethodSignature> stepMethodSignature) {
            this.listener.stepMethodSignature = stepMethodSignature.orElse(null);
            return this;
        }

        public Builder documentation(DocumentationItem documentation) {
            this.listener.documentation = documentation;
            return this;
        }

        public Builder producedEvents(Set<NameRequired> producedEvents) {
            this.listener.producedEvents.addAll(producedEvents);
            return this;
        }

        @Deprecated
        public Builder toExternals(Collection<String> toExternals) {
            this.listener.toExternals.addAll(toExternals);
            return this;
        }

        public Builder toExternalsByEvent(Map<NameRequired, List<String>> toExternalsByEvent) {
            this.listener.toExternalsByEvent.putAll(toExternalsByEvent);
            return this;
        }

        public Builder processNames(Set<String> processNames) {
            this.listener.processNames.addAll(processNames);
            return this;
        }

        public Builder fromExternals(Collection<String> fromExternals) {
            this.listener.fromExternals.addAll(fromExternals);
            return this;
        }

        public Builder aggregate(Optional<String> aggregate) {
            this.listener.aggregate = aggregate.orElse(null);
            return this;
        }
    }
}

