/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNodeName;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;

public class MessageListenersPerEvent {
    private HashMap<String, List<String>> eventToListenersMap = new HashMap();

    public List<DomainProcessGraphNodeName> locateToInternals(MessageListener stepDoc) {
        ArrayList<DomainProcessGraphNodeName> tos = new ArrayList<DomainProcessGraphNodeName>();
        for (NameRequired producedEvent : stepDoc.producedEvents()) {
            List<String> consumingSteps = this.eventToListenersMap.get(producedEvent.name());
            if (consumingSteps == null) continue;
            tos.addAll(consumingSteps.stream().map(DomainProcessGraphNodeName::new).collect(Collectors.toList()));
        }
        return tos;
    }

    public static class Builder {
        private MessageListenersPerEvent listenersPerEvent = new MessageListenersPerEvent();

        public Builder withMessageListener(MessageListener processStepDoc) {
            Optional<StepMethodSignature> optionalStepMethodSignature = processStepDoc.stepMethodSignature();
            Optional<Object> consumedEventName = optionalStepMethodSignature.isPresent() ? optionalStepMethodSignature.get().consumedEventName() : Optional.empty();
            if (consumedEventName.isPresent()) {
                String presentConsumedEventName = (String)consumedEventName.get();
                List listeners = this.listenersPerEvent.eventToListenersMap.computeIfAbsent(presentConsumedEventName, key -> new ArrayList());
                listeners.add(processStepDoc.documentation().name());
            }
            return this;
        }

        public MessageListenersPerEvent build() {
            return this.listenersPerEvent;
        }
    }
}

