/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.util.Equality;

public class UbiquitousLanguageEntry
implements Comparable<UbiquitousLanguageEntry> {
    private Optional<String> moduleName = Optional.empty();
    private DocumentationItem componentDoc;
    private String type;

    private UbiquitousLanguageEntry() {
    }

    public Optional<String> moduleName() {
        return this.moduleName;
    }

    public DocumentationItem componentDoc() {
        return this.componentDoc;
    }

    public String getType() {
        return this.type;
    }

    public String qualifiedName() {
        Optional<String> optionalModuleName = this.moduleName();
        if (optionalModuleName.isPresent()) {
            return this.componentDoc().name() + " (" + optionalModuleName.get() + ")";
        }
        return this.componentDoc().name();
    }

    @Override
    public int compareTo(UbiquitousLanguageEntry o) {
        return this.comparisonIndex().compareTo(o.comparisonIndex());
    }

    private String comparisonIndex() {
        return this.qualifiedName() + this.type;
    }

    public boolean equals(Object obj) {
        return Equality.referenceEquals((Object)this, (Object)obj).orElse(other -> new EqualsBuilder().append((Object)this.comparisonIndex(), (Object)other.comparisonIndex()).build());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.comparisonIndex()).build();
    }

    public static class Builder {
        private UbiquitousLanguageEntry entry = new UbiquitousLanguageEntry();

        public Builder moduleName(String moduleName) {
            this.entry.moduleName = Optional.of(moduleName);
            return this;
        }

        public Builder componentDoc(DocumentationItem componentDoc) {
            this.entry.componentDoc = componentDoc;
            return this;
        }

        public Builder type(String type) {
            this.entry.type = type;
            return this;
        }

        public UbiquitousLanguageEntry build() {
            Objects.requireNonNull(this.entry.type);
            Objects.requireNonNull(this.entry.componentDoc);
            return this.entry;
        }
    }
}

