/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.entitydoc;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.ComponentDocFactory;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.entitydoc.EntityDoc;
import poussecafe.doc.model.entitydoc.EntityDocId;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.domain.AggregateFactory;
import poussecafe.domain.DomainException;
import poussecafe.domain.Entity;

public class EntityDocFactory
extends AggregateFactory<EntityDocId, EntityDoc, EntityDoc.Attributes> {
    private ComponentDocFactory componentDocFactory;
    private ModuleDocRepository moduleDocRepository;
    private DocletEnvironment docletEnvironment;
    private static final int KEY_TYPE_INDEX = 0;
    private ClassDocPredicates classDocPredicates;

    public EntityDoc newEntityDoc(ModuleDocId moduleDocId, TypeElement entityClassDoc) {
        if (!this.isEntityDoc(entityClassDoc)) {
            throw new DomainException("Class " + entityClassDoc.getQualifiedName() + " is not an entity");
        }
        String name = EntityDocFactory.name(entityClassDoc);
        EntityDocId id = EntityDocId.ofClassName(entityClassDoc.getQualifiedName().toString());
        EntityDoc entityDoc = (EntityDoc)this.newAggregateWithId((Object)id);
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ((EntityDoc.Attributes)entityDoc.attributes()).moduleComponentDoc().value((Object)new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(this.componentDocFactory.buildDoc(name, entityClassDoc)).build());
        entityDoc.idClassName(this.idClassName(entityClassDoc));
        return entityDoc;
    }

    public String idClassName(TypeElement aggregateClassDoc) {
        DeclaredType superclass = (DeclaredType)aggregateClassDoc.getSuperclass();
        TypeElement keyType = (TypeElement)this.docletEnvironment.getTypeUtils().asElement(superclass.getTypeArguments().get(0));
        return keyType.getQualifiedName().toString();
    }

    public boolean isEntityDoc(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, Entity.class);
    }

    public static String name(TypeElement classDoc) {
        return classDoc.getSimpleName().toString();
    }
}

