/*
 * Decompiled with CFR 0.152.
 */
package process;

import domain.MyAggregate;
import domain.MyDomainEvent;
import domain.MyFactory;
import domain.MyRepository;
import org.slf4j.LoggerFactory;
import poussecafe.messaging.DomainEventListener;
import poussecafe.process.DomainProcess;
import poussecafe.storable.IdentifiedStorable;
import process.CreateAggregate;
import process.MyCommand;

public class MyProcess
extends DomainProcess {
    private MyFactory factory;
    private MyRepository repository;

    public void handle(CreateAggregate command) {
        MyAggregate aggregate = this.factory.buildAggregate(command.getKey());
        this.runInTransaction(MyAggregate.class, () -> this.repository.add((IdentifiedStorable)aggregate));
    }

    public void handle(MyCommand command) {
        this.runInTransaction(MyAggregate.class, () -> {
            MyAggregate aggregate = (MyAggregate)this.repository.get((Object)command.getKey());
            aggregate.doSomeAction(command.getX());
            this.repository.update((IdentifiedStorable)aggregate);
        });
    }

    @DomainEventListener
    public void handle(MyDomainEvent event) {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Some action was succesfully executed");
    }
}

