/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import java.util.List;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.stubbing.StubberImpl;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.PrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DefaultPrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoMethodInvocationControl;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockitoStubberImpl
extends StubberImpl
implements PowerMockitoStubber {
    @Override
    public void when(Class<?> classMock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(classMock);
        this.addAnswersForStubbing(invocationControl);
    }

    public <T> T when(T instanceMock) {
        Object returnValue;
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(instanceMock);
        if (invocationControl == null) {
            returnValue = super.when(instanceMock);
        } else {
            this.addAnswersForStubbing(invocationControl);
            returnValue = instanceMock;
        }
        return (T)returnValue;
    }

    private void addAnswersForStubbing(MockitoMethodInvocationControl invocationControl) {
        MockitoInvocationHandler mockHandler = invocationControl.getInvocationHandler().getHandler();
        if (!(mockHandler instanceof MockHandler)) {
            throw new RuntimeException("Cannot perform \"when\" because of unknown mockhandler type " + mockHandler.getClass());
        }
        ((MockHandler)mockHandler).setAnswersForStubbing((List)Whitebox.getInternalState((Object)this, List.class));
    }

    @Override
    public <T> PrivatelyExpectedArguments when(T mock, Method method) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(method, "Method");
        this.prepareForStubbing(mock);
        return new DefaultPrivatelyExpectedArguments(mock, method);
    }

    @Override
    public <T> void when(T mock, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.prepareForStubbing(mock);
        Whitebox.invokeMethod(mock, (Object[])arguments);
    }

    @Override
    public <T> void when(T mock, String methodToExpect, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.prepareForStubbing(mock);
        Whitebox.invokeMethod(mock, (String)methodToExpect, (Object[])arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, Object ... arguments) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.when((T)classMock);
        Whitebox.invokeMethod(classMock, (Object[])arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, String methodToExpect, Object ... parameters) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.when((T)classMock);
        Whitebox.invokeMethod(classMock, (String)methodToExpect, (Object[])parameters);
    }

    @Override
    public <T> PrivatelyExpectedArguments when(Class<T> classMock, Method method) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(method, "Method");
        this.when((T)classMock);
        return new DefaultPrivatelyExpectedArguments(classMock, method);
    }

    private void assertNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private <T> void prepareForStubbing(T mock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(mock);
        this.addAnswersForStubbing(invocationControl);
    }
}

