/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.debugging.Localized;
import org.mockito.internal.exceptions.base.StackTraceFilter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.FilteredCGLIBProxyRealMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.matchers.MatchersPrinter;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocationcontrol.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.verification.StaticMockAwareVerificationMode;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.MockGateway;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoMethodInvocationControl
implements MethodInvocationControl {
    private final MethodInterceptorFilter methodInterceptorFilter;
    private final Set<Method> mockedMethods;
    private final Object delegator;

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptionFilter, Method ... methodsToMock) {
        this(methodInterceptionFilter, (Object)null, methodsToMock);
    }

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptionFilter, Object delegator, Method ... methodsToMock) {
        if (methodInterceptionFilter == null) {
            throw new IllegalArgumentException("Invocation Handler cannot be null.");
        }
        this.mockedMethods = this.toSet(methodsToMock);
        this.delegator = delegator;
        this.methodInterceptorFilter = methodInterceptionFilter;
    }

    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods != null && this.mockedMethods.contains(method);
    }

    private boolean isInVerificationMode() {
        return this.getVerificationMode() != null;
    }

    private VerificationMode getVerificationMode() {
        try {
            MockingProgress progress = (MockingProgress)Whitebox.invokeMethod(ThreadSafeMockingProgress.class, (String)"threadSafely", (Object[])new Object[0]);
            return this.getVerificationModeFromMockProgress(progress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private VerificationMode getVerificationModeFromMockProgress(MockingProgress mockingProgress) {
        if (mockingProgress == null) {
            return null;
        }
        if (mockingProgress instanceof ThreadSafeMockingProgress) {
            ThreadLocal threadLocal = (ThreadLocal)Whitebox.getInternalState((Object)mockingProgress, ThreadLocal.class);
            return this.getVerificationModeFromMockProgress((MockingProgress)threadLocal.get());
        }
        Localized verificationMode = (Localized)Whitebox.getInternalState((Object)mockingProgress, Localized.class);
        return verificationMode == null ? null : (VerificationMode)verificationMode.getObject();
    }

    public Object invoke(Object obj, Method method, Object[] arguments) throws Throwable {
        Object returnValue;
        int methodModifiers = method.getModifiers();
        if (this.hasDelegator() && !Modifier.isPrivate(methodModifiers) && !Modifier.isFinal(methodModifiers) && !Modifier.isStatic(methodModifiers) && this.hasBeenCaughtByMockitoProxy()) {
            returnValue = MockGateway.PROCEED;
        } else {
            boolean inVerificationMode = this.isInVerificationMode();
            if (WhiteboxImpl.isClass((Object)obj) && inVerificationMode) {
                this.handleStaticVerification((Class)obj);
            }
            if ((returnValue = this.performIntercept(this.methodInterceptorFilter, obj, method, arguments)) == null) {
                return MockGateway.SUPPRESS;
            }
        }
        return returnValue;
    }

    private void handleStaticVerification(Class<?> cls) {
        VerificationMode verificationMode = this.getVerificationMode();
        if (verificationMode instanceof StaticMockAwareVerificationMode) {
            ((StaticMockAwareVerificationMode)verificationMode).setClassMock(cls);
        }
    }

    private boolean hasBeenCaughtByMockitoProxy() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceFilter filter = new StackTraceFilter();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!filter.isBad(stackTraceElement)) continue;
            return true;
        }
        return false;
    }

    private Object performIntercept(MethodInterceptorFilter invocationHandler, final Object interceptionObject, final Method method, Object[] arguments) throws Throwable {
        MockitoInvocationHandler mockHandler = invocationHandler.getHandler();
        FilteredCGLIBProxyRealMethod cglibProxyRealMethod = new FilteredCGLIBProxyRealMethod(new RealMethod(){
            private static final long serialVersionUID = 4564320968038564170L;

            public Object invoke(Object target, Object[] arguments) throws Throwable {
                boolean isFinalSystemClass;
                Class type = Whitebox.getType((Object)interceptionObject);
                boolean bl = isFinalSystemClass = type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
                if (!isFinalSystemClass) {
                    MockRepository.putAdditionalState((String)"DontMockNextCall", (Object)true);
                }
                try {
                    return method.invoke(target, arguments);
                }
                catch (InvocationTargetException e) {
                    SafeExceptionRethrower.safeRethrow((Throwable)e.getCause());
                    return null;
                }
            }
        });
        Invocation invocation = new Invocation(interceptionObject, (MockitoMethod)new DelegatingMethod(method), arguments, SequenceNumber.next(), (RealMethod)cglibProxyRealMethod){
            private static final long serialVersionUID = -3679957412502758558L;

            protected String toString(List<Matcher> matchers, PrintSettings printSettings) {
                MatchersPrinter matchersPrinter = new MatchersPrinter();
                String method = Whitebox.getType((Object)this.getMock()).getName() + "." + this.getMethodName();
                String invocation = method + matchersPrinter.getArgumentsLine(matchers, printSettings);
                if (printSettings.isMultiline() || !matchers.isEmpty() && invocation.length() > (Integer)Whitebox.getInternalState(Invocation.class, (String)"MAX_LINE_LENGTH")) {
                    return method + matchersPrinter.getArgumentsBlock(matchers, printSettings);
                }
                return invocation;
            }
        };
        try {
            return mockHandler.handle(invocation);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForMethodInvocation((AssertionError)((Object)e));
            throw e;
        }
    }

    public Object replay(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as replay exists in Mockito.");
    }

    public Object reset(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as reset exists in Mockito.");
    }

    public Object verify(Object ... mocks) {
        if (mocks == null || mocks.length != 1) {
            throw new IllegalArgumentException("Must supply one mock to the verify method.");
        }
        return Mockito.verify((Object)mocks[0]);
    }

    public void verifyNoMoreInteractions() {
        try {
            MockitoInvocationHandler mockHandler = this.methodInterceptorFilter.getHandler();
            if (!(mockHandler instanceof MockHandler)) {
                throw new RuntimeException("Cannot perform verifyNoMoreInteractions because of unknown mockhandler type " + mockHandler.getClass());
            }
            InvocationContainer invocationContainer = ((MockHandler)mockHandler).getInvocationContainer();
            VerificationDataImpl data = new VerificationDataImpl(invocationContainer, null);
            VerificationModeFactory.noMoreInteractions().verify((VerificationData)data);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)e));
            throw e;
        }
    }

    private Set<Method> toSet(Method ... methods) {
        return methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
    }

    private boolean hasDelegator() {
        return this.delegator != null;
    }

    public MethodInterceptorFilter getInvocationHandler() {
        return this.methodInterceptorFilter;
    }
}

